package SOMA.resourceManagement.windows;


import SOMA.resourceManagement.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;

/** 
 * Finestra che consente di visualizzare le informazioni sugli allarmi:
 * numero, agente e valore del consumo giudicato anomalo. 
 * 
 * @see SOMA.resourceManagement.windows.AgentWin
 * @see SOMA.resourceManagement.windows.ProcessWin
 * @see SOMA.resourceManagement.windows.NetworkWin
 * @see SOMA.resourceManagement.windows.ThresholdWin
 * @see SOMA.resourceManagement.windows.PRMWindow
 *
 * @author Silvia Vecchi
 */
public class AlarmWin extends JFrame implements WindowListener {
	
	public static final  String PICTURE_PATH = "SOMA"+File.separator+"gui"+File.separator+"picture"+File.separator;
	
	protected Panel1 pan1;
  protected Panel2 pan2;
  protected Panel3 pan3;
	protected Container cont;
	protected PlaceResourceManager prm;
	//non  molto pulito, ma per recuperare i valori delle soglie devo interrogare il prm
	
	public AlarmWin(PlaceResourceManager prm) {
		super("Resource Consumption Alarms");
		this.prm=prm;
		setBounds(30,430,550,300);
		cont=getContentPane();
	      pan1=new Panel1();
	      pan1.setLayout(new GridLayout(5,1,5,5));
            pan2=new Panel2();
	      pan2.setLayout(new GridLayout(5,1,5,5));
            pan3=new Panel3();
	      pan3.setLayout(new GridLayout(5,1,5,5));
		cont.add(pan1, BorderLayout.WEST);
		cont.add(pan2, BorderLayout.CENTER);
		cont.add(pan3, BorderLayout.EAST);
		setVisible(true);
	}
	
	
  public void windowOpened(WindowEvent e){}
  public void windowClosing(WindowEvent e)
  	{dispose();}
  public void windowClosed(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowActivated(WindowEvent e){}
  public void windowDeactivated(WindowEvent e){}


  private class Panel1 extends JPanel { 
      JLabel res, cpuLabel, memLabel, netLabel, fileLabel;
        	
  	public Panel1(){
  	  res=new JLabel("RESOURCE");
  	  cpuLabel=new JLabel("      CPU ", new ImageIcon(PICTURE_PATH+"RadarMaxi.gif"), SwingConstants.LEFT);
  	  memLabel=new JLabel("     Memory ", new ImageIcon(PICTURE_PATH+"MemoryMaxi.gif"), SwingConstants.LEFT);
  	  netLabel=new JLabel("     Band Width ", new ImageIcon(PICTURE_PATH+"Connect.gif"), SwingConstants.LEFT);
  	  fileLabel=new JLabel("    File R/W Operations   ", new ImageIcon(PICTURE_PATH+"CartAggiorna.gif"), SwingConstants.LEFT);
        add(res);
        add(cpuLabel);
        add(memLabel);
        add(netLabel);
        add(fileLabel);
      }
  }// Panel1


  private class Panel2 extends JPanel { 
  	JLabel alarm;
      JTextField cpuAlNum, memAlNum, netAlNum, fileAlNum;
  	int num;
  	
  	public Panel2(){
  	  alarm=new JLabel(" ALARM NUMBER");
  	  num=prm.getCpuAlarmNum();
  	  cpuAlNum=new JTextField(Integer.toString(num));
  	  cpuAlNum.setEditable(false);
  	  num=prm.getMemAlarmNum();
  	  memAlNum=new JTextField(Integer.toString(num));
  	  memAlNum.setEditable(false);
  	  num=prm.getNetAlarmNum();
        netAlNum=new JTextField(Integer.toString(num));
        netAlNum.setEditable(false);
        num=prm.getFileAlarmNum();
        fileAlNum=new JTextField(Integer.toString(num));
        fileAlNum.setEditable(false);
        add(alarm);
        add(cpuAlNum);
        add(memAlNum);
        add(netAlNum);
        add(fileAlNum);
      }
  }// Panel2

private class Panel3 extends JPanel { 
  	JLabel infoLabel;
      JList cpuAlInfo, memAlInfo, netAlInfo, fileAlInfo;
      JScrollPane cpuPane, memPane, netPane, filePane;
  	Enumeration enum;
      String[] stringArray;

  	
  	public Panel3(){
  	  infoLabel=new JLabel(" AGENT AND ALARM VALUE");
        add(infoLabel);
  	  
        enum = (prm.getCpuAlarmInfo()).elements();
        stringArray=creaStringhe(enum, new String("cpu"));
        if (stringArray!=null) cpuAlInfo=new JList(stringArray);
        else cpuAlInfo=new JList();
        //cpuAlInfo.setEditable(false);
        cpuAlInfo.setVisibleRowCount(2);
        cpuPane=new JScrollPane(cpuAlInfo);
        add(cpuPane);

  	  enum = (prm.getMemAlarmInfo()).elements();
        stringArray=creaStringhe(enum, new String("mem"));
        if (stringArray!=null) memAlInfo=new JList(stringArray);
        else memAlInfo=new JList();
        //memAlInfo.setEditable(false);
        memAlInfo.setVisibleRowCount(2);
        memPane=new JScrollPane(memAlInfo);
        add(memPane);

        enum = (prm.getNetAlarmInfo()).elements();
        stringArray=creaStringhe(enum, new String("net"));
        if (stringArray!=null) netAlInfo=new JList(stringArray);
        else netAlInfo=new JList();
        //netAlInfo.setEditable(false);
        netAlInfo.setVisibleRowCount(2);
        netPane=new JScrollPane(netAlInfo);
        add(netPane);

        enum = (prm.getFileAlarmInfo()).elements();
        stringArray=creaStringhe(enum, new String("file"));
        if (stringArray!=null) fileAlInfo=new JList(stringArray);
        else fileAlInfo=new JList();
        //fileAlInfo.setEditable(false);
        fileAlInfo.setVisibleRowCount(2);
        filePane=new JScrollPane(fileAlInfo);
        add(filePane);
      }

     String[] creaStringhe(Enumeration en, String s){
        LinkedList list=new LinkedList();
        EventInfo info;
        String array[], u;
        int num=0;
        if (s.equals("cpu")) u="%";
        else if (s.equals("mem")) u="Bytes";
             else if (s.equals("net")) u="Av.Bytes/sec";
                  else if (s.equals("file")) u="Av.Op./sec";
                       else u=" ";
        for (; en.hasMoreElements();){
          info=(EventInfo)en.nextElement();
          list.add(info.agID+" :    "+Float.toString(info.cons)+" "+u);
          num+=1;
        }
        if (num>0){
          array=new String[num];
          list.toArray(array);
          return array;
        }
        else return null;
     }// creaStringhe


  }// Panel3


}
    


	