package SOMA.resourceManagement.windows;


import SOMA.resourceManagement.*;
import SOMA.resourceManagement.res.*;
import javax.swing.table.*;

public class AgentWinData extends AbstractTableModel implements MonitoringManagerListener{

protected PlaceResourceManager prm;
protected AgentInfo[] data;
protected String[] head={"Name","CPU","Memory",
                         "Tcp in","Tcp out",
                         "Udp in","Udp out",
                         "File in","File out"};


public AgentWinData(PlaceResourceManager prm){
		super();
		this.prm = prm;
		prm.monitoringManager.addMonitoringManagerListener(this);

	}


public int getColumnCount()
	{return 9;}


public String getColumnName(int columnIndex)
	{return head[columnIndex];}


public int getRowCount(){
  if(data==null) return 0;
  return data.length;
  }


public String getName(int r)
	{return data[r].agID.toString();}


public int getIntValueAt(int rowIndex, int columnIndex){
  switch(columnIndex){
  	case 1:return (int)data[rowIndex].cpu;
  	case 2:return (int)data[rowIndex].mem;
  	case 3:return (int)data[rowIndex].tcp_in;
  	case 4:return (int)data[rowIndex].tcp_out;
  	case 5:return (int)data[rowIndex].udp_in;
  	case 6:return (int)data[rowIndex].udp_out;
  	case 7:return (int)data[rowIndex].file_in;
	  case 8:return (int)data[rowIndex].file_out;
  	}
  return 0;
  }


public Object getValueAt(int rowIndex, int columnIndex){
	if(columnIndex==0) return data[rowIndex].agID.toString();
    return ""+getIntValueAt(rowIndex,columnIndex);
	}


public void update(AgentInfo[] data){
  this.data=data;
  fireTableDataChanged();
	}

public AgentWinData freeze(){
	 AgentWinData dup=new AgentWinData(prm);
	 dup.update((AgentInfo[])data.clone());
	 return dup;
	 }

public void exit()
	{prm.monitoringManager.removeMonitoringManagerListener(this);}

public void alarm(MonitoringManagerEvent ev){}
public void update(ProcessInfo[] info){}
public void update(NetworkInfo info){}


}