package SOMA.resourceManagement.windows;


import SOMA.resourceManagement.*;


import java.awt.event.*;
import javax.swing.*;


/** 
 * Finestra che visualizza le informazioni relative ai vari agenti presenti sul place.
 * 
 * @see SOMA.resourceManagement.PlaceResourceManager
 * @see SOMA.resourceManagement.windows.ProcessWin
 * @see SOMA.resourceManagement.windows.NetworkWin
 * @see SOMA.resourceManagement.windows.ThresholdWin
 * @see SOMA.resourceManagement.windows.AlarmWin
 * @see SOMA.resourceManagement.windows.PRMWindow
 *
 * @author Luca Armani 
 */

class AgentWin extends JFrame implements ActionListener,WindowListener{ 

protected AgentWinData data;
protected PlaceResourceManager prm;

public AgentWin(PlaceResourceManager prm){
  super("Agent Monitor");
  this.prm=prm;
  setSize(500,300);
  setJMenuBar(myMenuBar());
  addWindowListener(this);
  data=new AgentWinData(prm);
  JTable tab=new JTable(data);
  tab.setRowSelectionAllowed(false);
  tab.setColumnSelectionAllowed(true);
  getContentPane().add(new JScrollPane(tab));
  setVisible(true);
  }



public void actionPerformed(ActionEvent e){
  Object x=e.getSource();
  String label;
  if(x instanceof JMenuItem){
    label=((JMenuItem)x).getText();
    if(label.equals("About...")) 
    	help();
    else
    if(label.equals("CPU usage"))
    	new AgentWinPie(this,data,1);
    if(label.equals("Memory allocation"))
    	new AgentWinPie(this,data,2);
    if(label.equals("TCP read operations"))
    	new AgentWinPie(this,data,3);
    if(label.equals("TCP write operations"))
    	new AgentWinPie(this,data,4);
    if(label.equals("UDP read operations"))
    	new AgentWinPie(this,data,5);
    if(label.equals("UDP write operations"))
    	new AgentWinPie(this,data,6);
    if(label.equals("File read operations"))
    	new AgentWinPie(this,data,7);
    if(label.equals("File write operations"))
    	new AgentWinPie(this,data,8);
    	
    }
  }



public void help(){
  JOptionPane.showMessageDialog(null,
    "University of Bologna\nJVM Monitor\nwritten with JVMPI v1",
    "About",JOptionPane.INFORMATION_MESSAGE);   
  }


 


protected JMenuBar myMenuBar(){
  JMenuBar menubar;
  JMenu menu;
  JMenuItem elem;
  menubar=new JMenuBar();
  menu=new JMenu("Plot");
  elem=new JMenuItem("CPU usage");
  elem.addActionListener(this);
  menu.add(elem);
  elem=new JMenuItem("Memory allocation");
  elem.addActionListener(this);
  menu.add(elem);
  elem=new JMenuItem("TCP read operations");
  elem.addActionListener(this);
  menu.add(elem);
  elem=new JMenuItem("TCP write operations");
  elem.addActionListener(this);
  menu.add(elem);
  elem=new JMenuItem("UDP read operations");
  elem.addActionListener(this);
  menu.add(elem);
  elem=new JMenuItem("UDP write operations");
  elem.addActionListener(this);
  menu.add(elem);
  elem=new JMenuItem("File read operations");
  elem.addActionListener(this);
  menu.add(elem);
  elem=new JMenuItem("File write operations");
  elem.addActionListener(this);
  menu.add(elem);
  menubar.add(menu);
  menu=new JMenu("Help");
  elem=new JMenuItem("About...");
  elem.addActionListener(this);
  menu.add(elem);
  menubar.add(menu);  
  return menubar;
  }  
  

public void windowOpened(WindowEvent e){}
public void windowClosing(WindowEvent e)
  {dispose(); data.exit(); }
public void windowClosed(WindowEvent e){}
public void windowIconified(WindowEvent e){}
public void windowDeiconified(WindowEvent e){}
public void windowActivated(WindowEvent e){}
public void windowDeactivated(WindowEvent e){}


}