package SOMA.resourceManagement.res;

/**
 * Un oggetto JvmMonitor implementa un monitor per la JVM che usa le
 * caratteristiche di JVMPI. Mediante i metodi di tale oggetto 
 * possibile recuperare lo stato dei thread attivi.
 *
 * @author  Luca Armani<a href=mailto:outoftime@libero.it>outoftime@libero.it</a>
 * @version 2, 1/10/2000
 * @see     res.ProcessMonitor
 */


public class JvmMonitor{

   /**
     * Costruttore.
     */
public JvmMonitor()
{init();}


   /**
     * Ritorna le statistiche di tutti i thread attivi.
     */
public native ThreadStat[] getThreadStat();

private native void init();

   /**
     * Ritorna la rappresentazione di questo oggetto.
     */
public String toString()
  {return "JvmMonitor";}

   /**
     * Ritorna la versione della classe JvmManager.
     */
public int getVersion()
  {return 2;}

   /**
     * Carica una classe esterna. La classe deve essere public e contentere
     * il metodo <code>static void main(String[] args)</code>. Viene creato
     * un nuovo thread che esegue tale metodo.
     *
     * @param      clazz   il nome della classe (completo di package)
     * @param      args    gli argomenti da passare al main
     * @exception  Exception  se la classe non pu essere trovata, se
     *             non ha accesso public o se non possiede un main
     */
public static void run(String clazz,String[] args)
  throws Exception
//use fully qualified name
  {
  MainThread t;
  t=new MainThread(clazz,args);
  t.start();
  }




static
  {
  try{System.loadLibrary("jvmmonitor");}   //carica dll
  catch(UnsatisfiedLinkError err)
    {
    throw new RuntimeException("Unable to find "+
      System.mapLibraryName("jvmmonitor")+" in path "+
      System.getProperty("java.library.path"));
    }
  }

}







