
package SOMA.resourceManagement;

import java.io.PrintStream;


/** 
 * Classe che raggruppa i valori delle soglie di consumo delle varie risorse
 * 
 * @see SOMA.resourceManagement.SetTresholdCommand
 *
 * @author Silvia Vecchi
 */

public class Threshold
{
	/** Soglia sull'occupazione di CPU (in %) */
  public float cpu;     
  /** Soglia sull'occupazione di memoria (in bytes) */
  public float mem;      
  /** Soglia sulle letture da file (in numero di operazioni al sec) */  
  public float file_in; 
  /** Soglia sulle scritture su file (in numero di operazioni al sec) */  
  public float file_out; 
	/** Soglia sull'occupazione di banda (in bytes medi al secondo) */
	public float band_width; 
	/*public float tcp_in;   // in bytes medi al secondo 
	public float tcp_out;  // in bytes medi al secondo 
	public float udp_in;   // in bytes medi al secondo 
	public float udp_out;  // in bytes medi al secondo */
	
	// valori di default, da sostituirsi con valori sensati...
	/** Valore di default della soglia sull'occupazione di CPU (in %) */
  static final float CPU = 10;
  /** Valore di default della soglia sull'occupazione di memoria (in bytes) */
	static final float MEM = 100000;
	/** Valore di default della soglia sulle letture da file (in numero di operazioni al sec) */  
	static final float FILE_IN = 100000;
	/** Valore di default della soglia sulle scritture su file (in numero di operazioni al sec) */  
	static final float FILE_OUT = 100000;
	/** Valore di default della soglia sull'occupazione di banda (in bytes medi al secondo) */
	static final float BAND_WIDTH =100000;
	/*static final float TCP_IN = 1;
	static final float TCP_OUT = 1;
	static final float UDP_IN = 1;
	static final float UDP_OUT = 1;*/
	
	
	/** Costruttore senza argomenti, setta tutte le soglie ai valori di default */
	public Threshold()
	{
		cpu = CPU;
		mem = MEM;
		file_in = FILE_IN;
		file_out = FILE_OUT;
		band_width = BAND_WIDTH;
		/*tcp_in = TCP_IN;
		tcp_out = TCP_OUT;
		udp_in = UDP_IN;
		udp_out = UDP_OUT;*/
	}
	
		
  // Rivedere cosa effettivamente  necessario sincronizzare...
  
  
  /** Setta tutte le soglie ai valori passati come argomenti */
  public synchronized void setAll (float cpu, float mem, 
  		                             float file_in, float file_out,
								                   float band_width)
  {
  	this.cpu = cpu;
	  this.mem = mem;
	  this.file_in = file_in;
	  this.file_out = file_out;
	  this.band_width = band_width;
	  /*this.tcp_in = tcp_in;
	  this.tcp_out = tcp_out;
	  this.udp_in = udp_in;
	  this.udp_out = udp_out;*/
  }
  
  /** Setta tutte le soglie ai valori di default */
  public synchronized void setDefaultAll()
  {
	cpu      = CPU;
	mem      = MEM;
	file_in  = FILE_IN;
	file_out = FILE_OUT;
	band_width = BAND_WIDTH;
	/*tcp_in   = TCP_IN;
	tcp_out  = TCP_OUT;
	udp_in   = UDP_IN;
	udp_out  = UDP_OUT;*/
	
  }
  
  /** Setta il valore di soglia della cpu */
  public synchronized void setCpu(float val)
  {
  	cpu = val;
  }
  
  /** Setta il valore di soglia della cpu a quello di default */
  public synchronized void setDefaultCpu()
  {
  	cpu = CPU;
  }
  
  /** Setta il valore di soglia della mem */
  public synchronized void setMem(float val)
  {
  	mem = val;
  }
  
  /** Setta il valore di soglia della mem a quello di default */
  public synchronized void setDefaultMem()
  {
  	mem = MEM;
  }
  
  /** Setta il valore di soglia del numero di operazioni di lettura da file */
  public synchronized void setFile_in(float val)
  {
  	file_in = val;
  }
  
  /** Setta il valore di soglia del numero di operazioni di lettura da file 
    * a quello di default
	*/
  public synchronized void setDefaultFile_in()
  {
  	file_in = FILE_IN;
  }
  
  /** Setta il valore di soglia del numero di operazioni di scrittura su file */
  public synchronized void setFile_out(float val)
  {
  	file_out = val;
  }
  
  /** Setta il valore di soglia del numero di operazioni di scrittura su file
    * a quello di default */
  public synchronized void setDefaultFile_out()
  {
  	file_out = FILE_OUT;
  }
  
  
  
  
  /** Setta il valore di soglia dell'occupazione di banda */
  public synchronized void setBand_width(float val)
  {
  	band_width = val;
  }
  
  /** Setta il valore di soglia dell'occupazione di banda 
    * a quello di default */
  public synchronized void setDefaultBand_width()
  {
  	band_width = BAND_WIDTH;
  }
  
  
  
  
  
  /** Setta il valore di soglia dei bytes medi al secondo letti da segmenti TCP */
  /*public synchronized void setTcp_in(float val)
  {
  	tcp_in = val;
  }*/
  
  /** Setta il valore di soglia dei bytes medi al secondo letti da segmenti TCP
    * a quello di default 
	*/
  /*public synchronized void setDefaultTcp_in()
  {
  	tcp_in = TCP_IN;
  }*/
  
   /** Setta il valore di soglia dei bytes medi al secondo scritti su segmenti TCP */
  /*public synchronized void setTcp_out(float val)
  {
  	tcp_out = val;
  }*/
  
  /** Setta il valore di soglia dei bytes medi al secondo scritti su segmenti TCP
    * a quello di default 
	*/
  /*public synchronized void setDefaultTcp_out()
  {
  	tcp_out = TCP_OUT;
  }*/
  
  /** Setta il valore di soglia dei bytes medi al secondo letti da pacchetti UDP */ 
  /*public synchronized void setUdp_in(float val)
  {
  	udp_in = val;
  }*/
  
  /** Setta il valore di soglia dei bytes medi al secondo letti da pacchetti UDP
    * a quello di default 
	*/
  /*public synchronized void setDefaultUdp_in()
  {
  	udp_in = UDP_IN;
  }*/
  
  /** Setta il valore di soglia dei bytes medi al secondo scritti su pacchetti UDP */
  /*public synchronized void setUdp_out(float val)
  {
  	udp_out = val;
  }*/
  
  /** Setta il valore di soglia dei bytes medi al secondo scritti su pacchetti UDP
    * a quello di default 
	*/
  /*public synchronized void setDefaultUdp_out()
  {
  	udp_out = UDP_OUT;
  }*/
  	
	
  // Da aggiungere: metodo di lettura soglie da file
  
  	
  /** Stampa sullo stream passato come argomento i valori di tutte le soglie */ 	
  public void print(PrintStream out)
  {
	out.println("cpu      = " + cpu);			 
	out.println("mem      = " + mem);
	out.println("file_in  = " + file_in);
	out.println("file_out = " + file_out);
	out.println("band_width = " + band_width);
	/*out.println("tcp_in   = " + tcp_in);
	out.println("tcp_out  = " + tcp_out);
  out.println("udp_in   = " + udp_in);
  out.println("udp_out  = " + udp_out);*/
  }
  
  // Non  indispensabile, fa comodo per stampare nella finestra di Debug
  // e pu tornare utile per scrivere le soglie su file di testo
  /** Restituisce una stringa con tutte le soglie nel formato "risorsa = valoreSoglia"
    * una sotto l'altra
	  */
  public String printString()
  {
  	return "cpu      = " + cpu + "\n" +
	         "mem      = " + mem + "\n" +
		       "file_in  = " + file_in + "\n" +
		       "file_out = " + file_out + "\n" +
		       "band_width = " + band_width;
		       /*"tcp_in   = " + tcp_in + "\n" +
		       "tcp_out  = " + tcp_out + "\n" +
		       "udp_in   = " + udp_in + "\n" +
		       "udp_out  = " + udp_out;*/
  }

}
	