package SOMA.resourceManagement;

import SOMA.network.connection.*;

import java.io.PrintStream;



/** Comando che setta i valori di soglia dei consumi delle varie risorse.
  *
  * @author Silvia Vecchi
  */

public class SetThresholdCommand extends Command
{
  String resName;
  float val;

  /** Costruttore dato il nome della risorsa e il vaore da settare. */
  public SetThresholdCommand( String resName, float val )
  {
    this.resName = resName;
    this.val = val;
  }

  /** Setta la soglia della risorsa, il cui nome  passato come argomento, 
    * ad un nuovo valore, passato anch'esso come argomento.
    */
  public void run()
  {
    PrintStream out = env.out;
    if (resName.equals("cpu"))
     env.placeResourceManager.setCpuThreshold(val);
    else if (resName.equals("mem"))
          env.placeResourceManager.setCpuThreshold(val);
         else if (resName.equals("file_in"))
               env.placeResourceManager.setFile_inThreshold(val);
              else if (resName.equals("file_out"))
                    env.placeResourceManager.setFile_outThreshold(val);
                   else if (resName.equals("band_width"))
                         env.placeResourceManager.setBand_widthThreshold(val);
                        else out.println("Nome della risorsa scorretto");

  }
}