package SOMA.resourceManagement;

import SOMA.naming.*;

/** 
 * Classe che raggruppa le informazioni relative ad un evento di allarme 
 * sull'occupazione di banda.
 * 
 * @see SOMA.resourceManagement.MonitoringManagerEvent
 * @see SOMA.resourceManagement.CpuEvent
 * @see SOMA.resourceManagement.FileEvent
 * @see SOMA.resourceManagement.MemEvent
 *
 * @author Silvia Vecchi
 */

public class NetEvent extends MonitoringManagerEvent
{
  /** Costruttore dati agentId, thread e valore di consumo al momento dell'allarme */
	public NetEvent(Object source, AgentID agID,  Thread th, float val)
	{
		super(source, agID, th, val);
	}
	
	/** Restituisce la rappresentazione in stringa dell'oggetto */
	public String toString()
    {
		return "NetEvent: bandwidth threshold exeeded from "+info.thread.getName()+
		       "\nBandwidth consumption value = "+info.cons; 
    }	   
}