package SOMA.resourceManagement;

import java.util.*;
import SOMA.resourceManagement.res.*;

/**
 * Interfaccia che definisce i metodi che ogni Listener di Monitoring Manager
 * deve implementare.
 * Il metodo "alarm" viene implementato dai vari Alarm Handler, i metodi "update"
 * dalle finestre che visualizzano i dati del monitoraggio
 *
 * @see SOMA.resourceManagement.MonitoringManager
 * @see SOMA.resourceManagement.MonitoringManagerEvent
 *
 * @author Silvia Vecchi
 */

public interface MonitoringManagerListener extends EventListener
{
	public void alarm(MonitoringManagerEvent ev);
	public void update(AgentInfo[] info);
	public void update(ProcessInfo[] info);
	public void update(NetworkInfo info);

}