package SOMA.resourceManagement;

import java.util.*;

import SOMA.naming.*;

/** 
 * Classe che raggruppa le informazioni relative ad un evento di allarme 
 * rilevato dal Monitoring Manager.
 *
 * @see SOMA.resourceManagement.EventInfo
 * @see SOMA.resourceManagement.CpuEvent
 * @see SOMA.resourceManagement.FileEvent
 * @see SOMA.resourceManagement.MemEvent
 * @see SOMA.resourceManagement.NetEvent
 *
 * @author Silvia Vecchi
 */

public class MonitoringManagerEvent extends EventObject
{
	public EventInfo info;
	
	/** Costruttore dati agentId, thread e valore di consumo al momento dell'allarme */
  public MonitoringManagerEvent(Object source, AgentID agID, Thread th, float val)
	{
		super(source);
		this.info = new EventInfo(th, agID, val);
		
	}
	
	/** Restituisce la rappresentazione in stringa dell'oggetto */
  public String toString()
    {
		return "MonitoringManagerEvent: il thread "+info.thread.getName()+" ha superato la soglia di consumo di una risorsa"; 
    }	   
}