package SOMA.resourceManagement;

import SOMA.naming.*;

/** 
 * Classe che raggruppa le informazioni relative ad un evento di allarme 
 * sull'occupazione di memoria.
 * 
 * @see SOMA.resourceManagement.MonitoringManagerEvent
 * @see SOMA.resourceManagement.CpuEvent
 * @see SOMA.resourceManagement.FileEvent
 * @see SOMA.resourceManagement.NetEvent
 *
 * @author Silvia Vecchi
 */

public class MemEvent extends MonitoringManagerEvent
{
  /** Costruttore dati agentId, thread e valore di consumo al momento dell'allarme */
	public MemEvent(Object source, AgentID agID, Thread th, float val)
	{
		super(source, agID, th, val);
	}
	
	/** Restituisce la rappresentazione in stringa dell'oggetto */
	public String toString()
    {
		return "MemEvent: memory allocation threshold exeeded from "+info.thread.getName()+
		       "\nMemory allocation value = "+info.cons; 
    }	   
}