
package SOMA.resourceManagement;

import SOMA.agent.*;
import SOMA.gui.Debug;
import SOMA.resourceManagement.res.*;


import java.util.*;

/**
 * Classe che implementa un gestore per le situazioni di allarme relative
 * all'occupazione di memoria.
 * Interviene con livelli diversi di gravit: se  il primo allarme provocato
 * dall'agente, viene deschedulato e vengono abbassate le priorit dell'agente
 * stesso e di tutto il suo threadGroup; se  il secondo allarme provocato dallo
 * stesso agente sulla stessa risorsa, l'agente viene ucciso (con tutti i thread
 * che lo compongono)
 *
 * @see SOMA.resourceManagement.CpuAlarmsHandler
 * @see SOMA.resourceManagement.FileAlarmsHandler
 * @see SOMA.resourceManagement.NetAlarmsHandler
 *
 * @author Silvia Vecchi
 */

public class MemAlarmsHandler implements MonitoringManagerListener
{

	PlaceResourceManager prm;
	HashSet badAgents = new HashSet();
	Hashtable alarmsTab = new Hashtable();
	int alarmsNum = 0;

	/** Costruttore: assegna il riferimento a resourceManager e
	  * registra il listener presso monitoringManager
	  */
	public MemAlarmsHandler(PlaceResourceManager prm)
	{

		this.prm = prm;
		prm.monitoringManager.addMonitoringManagerListener(this);

	}

	/** Recupera il worker dell'agente che ha prodotto l'allarme e
	  * invoca firstAlarm o secondAlarm a seconda che l'agente abbia gi
	  * provocato o meno un altro allarme (sempre sulla stessa risorsa)
	  */
	public void alarm(MonitoringManagerEvent ev)
	{
		AgentWorker agW = null;

		try
		{
			agW = prm.env.agentManager.agentWorkerStore.getWorker(ev.info.agID);

			alarmsTab.put(ev.info.agID, ev.info);
			// controllo se l'agente  stato messo nella hashtable
		    Debug.outln("MemAlarmsHandler: alarm -> " + alarmsTab.get(ev.info.agID) + " inserito in alarmsTab");
	        alarmsNum+=1;
			Debug.outln("MemAlarmsHandler: alarm -> alarmsNum = " + alarmsNum);

		    if (agW != null)
		    {
			   Debug.outln("MemAlarmsHandler: alarm -> ThreadGroup dell'agente che ha prodotto l'allarme: " + ev.info.agID);
		       Debug.outln("MemAlarmsHandler: alarm -> ThreadGroup dell'agentWorker recuperato: " + agW.agentThreadGroup.getName());

			   if (!badAgents.contains(ev.info.agID))
			      firstAlarm(ev.info, agW);
			   else
			      secondAlarm(ev.info, agW);
		    }
		    else Debug.outln("MemAlarmsHandler: alarm -> " + ev.info.agID + " gi eliminato, non propago l'allarme");
		}
		catch(Exception ex)
		{
		   Debug.outln(ex.toString());
		   Debug.outln("MemAlarmsHandler: thread morto prima o durante l'esecuzione di alarm");
		}


	}




	/** Inserisce l'agente in badAgents, per segnalare in futuro
	  * il fatto che ha gi prodotto un allarme, invoca yield() sul thread
	  * che ha superato la soglia, abbassa di 1 la sua priorit e
	  *	quella massima di tutto il threadGroup dell'agente
	  */
    public void firstAlarm(EventInfo info, AgentWorker agW)
	{
	    Debug.outln("MemAlarmsHandler: firstAlarm -> inizio");

		try
		{
		  info.thread.yield();
		  Debug.outln("MemAlarmsHandler: firstAlarm -> yield su " + info.thread.getName());
		  Debug.outln("MemAlarmsHandler: firstAlarm -> priority di " + info.thread.getName() + ": " + info.thread.getPriority());
		  int tPri = info.thread.getPriority();
		  if (tPri > 1)
		     info.thread.setPriority(tPri - 1);
		  Debug.outln("MemAlarmsHandler: firstAlarm -> priority di " + info.thread.getName() + " abbassata : " + info.thread.getPriority());
		  Debug.outln("MemAlarmsHandler: firstAlarm -> Max priority dell'agentThreadGroup: " + agW.agentThreadGroup.getMaxPriority());
		  int tgPri = agW.agentThreadGroup.getMaxPriority();
		  if (tgPri > 1)
		     agW.agentThreadGroup.setMaxPriority(tgPri - 1);
		  Debug.outln("MemAlarmsHandler: firstAlarm -> Max priority dell'agentThreadGroup abbassata: " + agW.agentThreadGroup.getMaxPriority());
		  // lo inserisco in badAgents solo qua per evitare di inserircelo nel caso in cui ci siano problemi prima
	   	  if (badAgents.add(info.agID))
		    Debug.outln("MemAlarmsHandler: firstAlarm -> " + info.agID + " inserito in badAgents");
		  else
		  	Debug.outln("MemAlarmsHandler: firstAlarm -> problemi nell'inserimento di " + info.agID + " in badAgents");
		}
		catch(Exception ex)
		{
		  Debug.outln(ex.toString());
		  Debug.outln("MemAlarmsHandler: thread morto prima o durante l'esecuzione di firstAlarm");
		}

	}




	/** Se l'agente non  gi stato eliminato, uccide tutti i thread del suo gruppo
	  * e lo inserisce in killedAgents, in modo da segnalarne l'avvenuta eliminazione,
	  * altrimenti non fa nulla
	  */
	public void secondAlarm(EventInfo info, AgentWorker agW)
	{
		Debug.outln("MemAlarmsHandler: secondAlarm -> inizio");

		if (badAgents.remove(info.agID))
		  Debug.outln("MemAlarmsHandler: secondAlarm -> O.K. " + info.agID +" rimosso da badAgents");
	    else
		  Debug.outln("MemAlarmsHandler: secondAlarm -> problemi nella rimozione di " + info.agID +" da badAgents");

	    //if (agW.getStatus() != KILLED)
		if (!prm.killedAgents.containsKey(info.agID))
		{
		   synchronized(prm.killedAgents)
	       {
			  prm.killedAgents.put(info.agID, info);
	       }
		   if (prm.killedAgents.containsKey(info.agID))
		      Debug.outln("MemAlarmsHandler: secondAlarm -> O.K. " + info.agID +" inserito in killedAgents");
		   else Debug.outln("MemAlarmsHandler: secondAlarm -> problemi nell'inserimento di " + info.agID +" in killedAgents");

		   agW.kill();
		   Debug.outln("MemAlarmsHandler: secondAlarm -> " + info.agID +" killed (forse)");

	          /* if < condizione, quale ? >
		            agW.idle();
		         else
		            agW.kill();  */
		}
		else Debug.outln("MemAlarmsHandler: secondAlarm -> agente gi eliminato");
	}


	/** Restituisce la rappresentazione in stringa */
    public String toString()
    {
		return "MemAlarmsHandler";
    }


  public void update(AgentInfo[] info){}
	public void update(ProcessInfo[] info){}
	public void update(NetworkInfo info){}


}