package SOMA.resourceManagement;

import SOMA.naming.*;

import java.io.PrintStream;


/** 
 * Classe che raggruppa le informazioni relative ad un agente.
 * Rispetto alla classe AgentInfo, che estende, ha in pi il campo
 * 
 * Thread thread
 * 
 * che la rende non serializzabile ma che  indispensabile per poter intervenire
 * sugli agenti che si comportano in modo anomalo.
 * 
 * @see SOMA.resourceManagement.AgentInfo
 *
 * @author Silvia Vecchi
 */

public class FilteredInfo extends AgentInfo
{
	/** Riferimento al thread java */
	public Thread thread = null;
	
	/** Costruttore senza argomenti */
	public FilteredInfo ()
	{
		super();
		this.thread = null;
		
	}
	
	/** Costruttore per copia */	
	public FilteredInfo ( FilteredInfo info )
	{
		super(info);
    this.thread = info.thread;
	}
	
	/** Costruttore campo per campo */
	public FilteredInfo ( AgentID agID, Thread thread, 
	                      float cpu, long time, float mem, 
	                      float file_in, float file_out, 
						            float tcp_in, float tcp_out, 
						            float udp_in, float udp_out)
	{
	  this.agID = agID;
		this.thread = thread;
		this.cpu = cpu;
		this.time = time;
		this.mem = mem;
		this.file_in = file_in;
		this.file_out = file_out;
		this.tcp_in = tcp_in;
		this.tcp_out = tcp_out;
		this.udp_in = udp_in;
		this.udp_out = udp_out;
	}
	
	/** Metodo di stampa su stream di output */
	public void print(PrintStream out)
	{
		out.println("agID = " + agID);
		if (thread != null)
		  out.println("Thread: " + thread.getName());
		out.println("cpu = " + cpu);
		out.println("time = " + time);
		out.println("mem = " + mem);
		out.println("file_in / file_out = " + file_in + file_out);
	  out.println("tcp_in  / tcp_out = " + tcp_in + tcp_out);
		out.println("udp_in  / udp_out = " + udp_in + udp_out);
	}
	
  // Non  indispensabile,  comodo per stampare nella finestra di Debug e nel file dei consumi
	/** Metodo di stampa in formato stringa */
	public String printString()
    {
  	    return "agID     = " + agID + "   Thread: " + thread.getName() + "\n" +
	             "cpu      = " + cpu + "\n" +
		           "time     = " + time + "\n" +
	             "mem      = " + mem + "\n" +
		           "file_in / file_out = " + file_in + " / " + file_out + "\n" +
		           "tcp_in  / tcp_out  = " + tcp_in  + " / " + tcp_out  + "\n" +
		           "udp_in  / udp_out  = " + udp_in  + " / " + udp_out  + "\n" ;
    }

}
	