package SOMA.resourceManagement;

import SOMA.naming.*;

/** 
 * Classe che raggruppa le informazioni relative ad un evento di allarme 
 * sull'accesso a file.
 * 
 * @see SOMA.resourceManagement.MonitoringManagerEvent
 * @see SOMA.resourceManagement.CpuEvent
 * @see SOMA.resourceManagement.MemEvent
 * @see SOMA.resourceManagement.NetEvent
 *
 * @author Silvia Vecchi
 */

public class FileEvent extends MonitoringManagerEvent
{
	/** Costruttore dati agentId, thread e valore di consumo al momento dell'allarme */
	public FileEvent(Object source, AgentID agID, Thread th, float val)
	{
		super(source, agID, th, val);
	}
	
	/** Restituisce la rappresentazione in stringa dell'oggetto */
	public String toString()
    {
		return "FileEvent: file operations number threshold exeeded from "+info.thread.getName()+
		       "\nFile operations number = "+info.cons;
    }	   
}