package SOMA.resourceManagement;

import SOMA.naming.*;

/** 
 * Classe che raggruppa le informazioni relative ad un evento di allarme.
 * 
 * @see SOMA.resourceManagement.MonitoringManagerEvent
 * 
 *
 * @author Silvia Vecchi
 */


public class EventInfo
{
	public AgentID agID;
	public Thread thread;
	public float cons;
	
	/** Costruttore senza argomenti */
	public EventInfo()
	{
		this.agID = null;
		this.thread = null;
		this.cons = 0;
	}
	
	/** Costruttore dati agentId, thread e valore di consumo al momento dell'allarme */
	public EventInfo(Thread thread, AgentID agID, float val)
	{
		this.agID = agID;
		this.thread = thread;
		this.cons = val;
	}
}