package SOMA.resourceManagement;

import SOMA.naming.*;

/** 
 * Classe che raggruppa le informazioni relative ad un evento di allarme sulla CPU.
 * 
 * @see SOMA.resourceManagement.MonitoringManagerEvent
 * @see SOMA.resourceManagement.FileEvent
 * @see SOMA.resourceManagement.MemEvent
 * @see SOMA.resourceManagement.NetEvent
 *
 * @author Silvia Vecchi
 */

public class CpuEvent extends MonitoringManagerEvent
{
	
	/** Costruttore dati agentId, thread e valore di consumo al momento dell'allarme */
	public CpuEvent(Object source, AgentID agID, Thread th, float val)
	{
		super(source, agID, th, val);
	}
	
	/** Restituisce la rappresentazione in stringa dell'oggetto */
	public String toString()
    {
		return "CpuEvent: cpu threshold exeeded from " + info.thread.getName()+
		       "\nCpu consumption value (%) = "+info.cons; 
    }	   
}