

package SOMA.resourceManagement;

import SOMA.naming.*;

import java.io.PrintStream;

/** 
 * Classe che raggruppa le informazioni relative ad un agente.
 * E' serializzabile per poter essere utilizzata dagli agenti di monitoraggio.
 * 
 * @see SOMA.resourceManagement.FilteredInfo
 *
 * @author Silvia Vecchi
 */


public class AgentInfo implements java.io.Serializable
{
	/** Identificativo dell'agente */
	public AgentID agID;
	/** Occupazione di CPU (in %) */
	public float cpu; 
	/** Occupazione di CPU (in msec) */
	public long time;  
	/** Occupazione di memoria (in bytes) */
  public float mem;  
  /** Letture da file (in numero di operazioni al sec) */  
	public float file_in;   
	/** Scritture su file (in numero di operazioni al sec) */  
	public float file_out;
	/** Letture di segmenti TCP (in bytes medi al secondo) */
	public float tcp_in;    
	/** Scritture di segmenti TCP (in bytes medi al secondo) */
	public float tcp_out;  
	/** Letture di pacchetti UDP (in bytes medi al secondo) */
  public float udp_in;   
  /** Scritture di pacchetti UDP (in bytes medi al secondo) */
  public float udp_out;  
	
	/** Costruttore senza argomenti */
	public AgentInfo ()
	{
		this.agID = null;
		this.cpu = 0;
		this.time = 0;
		this.mem = 0;
		this.file_in = 0;
		this.file_out = 0;
		this.tcp_in = 0;
		this.tcp_out = 0;
		this.udp_in = 0;
		this.udp_out = 0;
	}

	
	/** Costruttore per copia */	
	public AgentInfo ( AgentInfo info )
	{
		this.agID = info.agID;
		this.cpu = info.cpu;
		this.time = info.time;
		this.mem = info.mem;
		this.file_in = info.file_in;
		this.file_out = info.file_out;
		this.tcp_in = info.tcp_in;
		this.tcp_out = info.tcp_out;
		this.udp_in = info.udp_in;
		this.udp_out = info.udp_out;
	}
	
	
	/** Costruttore da un oggetto di classe FilteredInfo */
	public AgentInfo ( FilteredInfo info )
	{
		this.agID = info.agID;
		this.cpu = info.cpu;
		this.time = info.time;
		this.mem = info.mem;
		this.file_in = info.file_in;
		this.file_out = info.file_out;
		this.tcp_in = info.tcp_in;
		this.tcp_out = info.tcp_out;
		this.udp_in = info.udp_in;
		this.udp_out = info.udp_out;
	}
	
	
	/** Costruttore campo per campo */
	public AgentInfo ( AgentID agID, float cpu, long time, float mem, 
	                   float file_in, float file_out, 
	                   float tcp_in, float tcp_out, 
			               float udp_in, float udp_out)
	{
	  this.agID = agID;
		this.cpu = cpu;
		this.time = time;
		this.mem = mem;
		this.file_in = file_in;
		this.file_out = file_out;
		this.tcp_in = tcp_in;
		this.tcp_out = tcp_out;
		this.udp_in = udp_in;
		this.udp_out = udp_out;
	}
	
	/** Metodo di stampa su stream di output */
	public void print(PrintStream out)
	{
	  out.println("agID = " + agID);
		out.println("cpu = " + cpu);
		out.println("time = " + time);
		out.println("mem = " + mem);
		out.println("file_in / file_out = " + file_in + file_out);
	  out.println("tcp_in  / tcp_out = " + tcp_in + tcp_out);
		out.println("udp_in  / udp_out = " + udp_in + udp_out);
	}
	
	
  // Non  indispensabile,  comodo per stampare nella finestra di Debug e nel file dei consumi
	/** Metodo di stampa in formato stringa */
	public String printString()
    {
  	    return "agID     = " + agID + "\n" +
	             "cpu      = " + cpu + "\n" +
		           "time     = " + time + "\n" +
	             "mem      = " + mem + "\n" +
		           "file_in / file_out = " + file_in + " / " + file_out + "\n" +
		           "tcp_in  / tcp_out  = " + tcp_in  + " / " + tcp_out  + "\n" +
		           "udp_in  / udp_out  = " + udp_in  + " / " + udp_out  + "\n" ;
    }

}
	