// Frame per l'interfaccia utente: fornisce una console grafica
// Con un input stream, un output stream, un buffered input reader
// Meccanismi di sincronizzazione per la chiusura.
//
// @author Livio Profiri
// @version 17/2/99



package SOMA.output;

/*
	This simple extension of the java.awt.Frame class
	contains all the elements necessary to act as the
	main window of an application.
 */

import java.awt.*;
import java.io.*;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;


public class OutputFrame extends Frame
{
	public transient PrintStream out;          // Analogo a System.out
	public transient BufferedReader inBufferedReader;
                                           // Utile per fare readLine()
	public TextFieldInputStream in;            // Analogo a System.in
  public JTextAreaOutputStream ListOut;
  //public ListOutputStream ListOut;  // Non  pubblico: PrintStream
                                     //   sufficiente, visto che estende OutputStream


  public Listener OnExitCommand;

  // Poco ortodosso ma comodo.
  // ExitCommand.exe() Viene chiamato all'uscita.
  // ExitCommand  un campo public, si pu fissare arbitrariamente.

  // Questa  l'inizializzazione di ExitCommand
  // questo pezzo di codice viene eseguito prima del costruttore.

	{
	  OnExitCommand = new Listener()
	    {
	      public void run() {}
      };
	}

	/*  Questo non era serializzabile!
	{ // Questa  l'inizializzazione di ExitActionListener
	  // questo codice viene eseguito prima del costruttore.
		  ExitActionListener =
	    new ActionListener() implements java.io.Serializable
	    {
	      public void actionPerformed(ActionEvent e)
	      {}
	    };
  }*/

	public boolean TimeToExit = false;
	  // Anche questo  poco elegante, ma molto pratico:
	  // All'uscita quindi vengono fatte 3 cose per facilitare
	  // il coordinamento:
	  //
	  // - viene messo a true TimeToExit
	  // - viene lanciato un notifyAll sul Monitor dell'OutputFrame
	  // - viene chiamato OnExitCommand.exe()

	public OutputFrame()
	{
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.

		//{{INIT_CONTROLS
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		setLayout(gridBagLayout);
		setVisible(false);
		setSize(400,300);
		setBackground(new Color(12632256));
		openFileDialog1 = new java.awt.FileDialog(this);
		openFileDialog1.setMode(FileDialog.LOAD);
		openFileDialog1.setTitle("Open");
		//$$ openFileDialog1.setLocation(40,277);
		//OutputList = new java.awt.List(4);

		jScrollPane = new JScrollPane();
		OutputList = new JTextArea();
		OutputList.setEditable( false );
		OutputList.setFont( new Font("Monospaced", Font.PLAIN, 12 ) );
  	jScrollPane = new JScrollPane( OutputList );
		//OutputList.setMultipleMode(true);
		//OutputList.setBounds(5,5,390,262);
		jScrollPane.setBounds(5,5,390,262);

		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.gridwidth = 2;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(5,5,5,5);
		//((GridBagLayout)getLayout()).setConstraints(OutputList, gbc);
		//add(OutputList);

	  ((GridBagLayout)getLayout()).setConstraints(jScrollPane, gbc);
		add(jScrollPane);

		InputLine = new java.awt.TextField();
		InputLine.setFont( new Font("Monospaced", Font.PLAIN, 12 ) );

		InputLine.setBounds(77,272,318,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 2;
		gbc.gridy = 2;
		gbc.weightx = 1.0;
		gbc.anchor = GridBagConstraints.SOUTH;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,0,5,5);
		((GridBagLayout)getLayout()).setConstraints(InputLine, gbc);
		add(InputLine);
		LabelInput = new java.awt.Label("Input line:");
		LabelInput.setBounds(10,274,67,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 2;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,10,0,0);
		((GridBagLayout)getLayout()).setConstraints(LabelInput, gbc);
		add(LabelInput);
		setTitle("SOMA");
		//}}

		//{{INIT_MENUS
		mainMenuBar = new java.awt.MenuBar();
		menu1 = new java.awt.Menu("File");
		miNew = new java.awt.MenuItem("New");
		miNew.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_N,false));
		//menu1.add(miNew);
		miOpen = new java.awt.MenuItem("Open...");
		miOpen.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_O,false));
		//menu1.add(miOpen);
		miSave = new java.awt.MenuItem("Save");
		miSave.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_S,false));
		//menu1.add(miSave);
		miSaveAs = new java.awt.MenuItem("Save As...");
		//menu1.add(miSaveAs);
		//menu1.addSeparator();
		miExit = new java.awt.MenuItem("Exit");
		menu1.add(miExit);
		mainMenuBar.add(menu1);
		menu2 = new java.awt.Menu("Edit");
		miCut = new java.awt.MenuItem("Cut");
		miCut.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_X,false));
		menu2.add(miCut);
		miCopy = new java.awt.MenuItem("Copy");
		miCopy.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_C,false));
		menu2.add(miCopy);
		miPaste = new java.awt.MenuItem("Paste");
		miPaste.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_V,false));
		menu2.add(miPaste);
		//mainMenuBar.add(menu2);
		menu3 = new java.awt.Menu("Help");
		mainMenuBar.setHelpMenu(menu3);
		miAbout = new java.awt.MenuItem("About..");
		menu3.add(miAbout);
		mainMenuBar.add(menu3);
		setMenuBar(mainMenuBar);
		//$$ mainMenuBar.setLocation(4,277);
		//}}

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		miOpen.addActionListener(lSymAction);
		miAbout.addActionListener(lSymAction);
		miExit.addActionListener(lSymAction);
		InputLine.addActionListener(lSymAction);
		//}}

		//ListOut          = new ListOutputStream( OutputList );
		ListOut          = new JTextAreaOutputStream( OutputList, jScrollPane.getVerticalScrollBar() );
		out              = new PrintStream( ListOut );
		in               = new TextFieldInputStream( InputLine );
		inBufferedReader = new BufferedReader( new InputStreamReader( in ), 1 );
	}

	public OutputFrame(String title)
	{
		this();
		setTitle(title);
	}

	public OutputFrame(String title, Listener OnExitCommand )
	{
		this();
		setTitle(title);
    this.OnExitCommand = OnExitCommand;
	}


	// Questo metodo  chiamato durante la deserializzazione
	private void readObject(java.io.ObjectInputStream in)
     throws IOException, ClassNotFoundException
  {
    in.defaultReadObject();

    // Questi campi non sono serializzabili
    //    Li devo ricostruire.

    inBufferedReader = new BufferedReader( new InputStreamReader( this.in ) );
                                               // Occhio a questo ^ confusione
                                               // col parametro di ingresso.
    out = new PrintStream( ListOut );
  }

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}
		super.setVisible(b);
	}

	static public void main(String args[])
	{
		OutputFrame MyFrame = new OutputFrame( "Bellino!" );
		MyFrame.setVisible(true);

	  Pipetta Pipa = new Pipetta( MyFrame.in, MyFrame.out );
		Pipa.start();
	}

	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();

		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}

	// Used for addNotify check.
	boolean fComponentsAdjusted = false;

	//{{DECLARE_CONTROLS
	java.awt.FileDialog openFileDialog1;
	//java.awt.List OutputList;
	JTextArea OutputList;
	JScrollPane jScrollPane;

	java.awt.TextField InputLine;
	java.awt.Label LabelInput;
	//}}

	//{{DECLARE_MENUS
	public java.awt.MenuBar mainMenuBar;
	public java.awt.Menu menu1;
	public java.awt.MenuItem miNew;
	public java.awt.MenuItem miOpen;
	public java.awt.MenuItem miSave;
	public java.awt.MenuItem miSaveAs;
	public java.awt.MenuItem miExit;
	public java.awt.Menu menu2;
	public java.awt.MenuItem miCut;
	public java.awt.MenuItem miCopy;
	public java.awt.MenuItem miPaste;
	public java.awt.Menu menu3;
	public java.awt.MenuItem miAbout;
	//}}

	class SymWindow extends java.awt.event.WindowAdapter implements Serializable
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == OutputFrame.this)
				Frame1_WindowClosing(event);
		}
	}

	void Frame1_WindowClosing(java.awt.event.WindowEvent event)
	{
		/*
		setVisible(false);	// hide the Frame
		dispose();			// free the system resources
		System.exit(0);		// close the application
		*/
		//{{CONNECTION
		// Create and show as non-modal
		(new QuitDialog(this, false)).setVisible(true);
		//}}
	}

	class SymAction implements java.awt.event.ActionListener, Serializable
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == miOpen)
				miOpen_Action(event);
			else if (object == miAbout)
				miAbout_Action(event);
			else if (object == miExit)
				miExit_Action(event);
			//else if (object == InputLine)
			//	InputLine_EnterHit(event);
		}
	}

	void miAbout_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from About Create and show as modal
		(new AboutDialog(this, true)).setVisible(true);
		//}}
	}

	void miExit_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from Exit Create and show as modal
		(new QuitDialog(this, true)).setVisible(true);
		//}}
	}

	void miOpen_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from Open... Show the OpenFileDialog
		int		defMode			= openFileDialog1.getMode();
		String	defTitle		= openFileDialog1.getTitle();
		String defDirectory	= openFileDialog1.getDirectory();
		String defFile			= openFileDialog1.getFile();

		openFileDialog1 = new java.awt.FileDialog(this, defTitle, defMode);
		openFileDialog1.setDirectory(defDirectory);
		openFileDialog1.setFile(defFile);
		openFileDialog1.setVisible(true);
		//}}
	}

	void InputLine_EnterHit(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// Add a string to the List... Get the contents of the TextField
		System.out.println( InputLine.getText() );
		//Out.println( InputLine.getText() );

		//InputLine.setText( "" );

		//OutputList.add(InputLine.getText());
		//OutputList.makeVisible( OutputList.getItemCount() - 1);
		//}}
	}

	// Metodo chiamato da QuitDialog.
	// Questi sono i costrutti di coordinamento fra il frame e
	//   l'applicazione che lo ha chiamato:
	//      - TimeToExit messo a true
	//      - Notifica ai thread che aspettano sul monitor dell' OutputFrame
	//      - Avvio del comando OnExitCommand, che di default non fa nulla.
	synchronized void Exit( java.awt.event.ActionEvent event )
	{
    TimeToExit = true;

    notifyAll();

    (new Thread( OnExitCommand, "OnExitCommand" )).start();
  }

	public synchronized void waitExit()
	{
	  while( !TimeToExit )
 	    try {wait();} catch( Exception e ) {}
  }

	/*
	synchronized void Exit()
	{
	  Active = new Boolean( false );
	  notifyAll();    // Avverte tutti quelli che aspettano sull'OutputFrame
	  //dispose();			// free the system resources
	}*/
	  /*
	  setVisible(false);	// hide the Frame
		dispose();			// free the system resources
		System.out.println( this.toString() + " FINALIZE " );
		try
		{
		  finalize();
		}
		catch( Throwable T )
		{
		  T.printStackTrace();
		}

		System.out.println( this.toString() + "DOPO IL FINALIZE " );
		//System.exit(0);		// close the application
  }
  */
	/*
	public boolean IsActive()
	{
	  return Active.booleanValue();
	}*/
	public interface Listener extends Serializable, Runnable
	{
	  //public void run();
	}

	public String getText()
	{
	  return ListOut.Target.getText();
	}

  public void setText(String t)
	{
	  ListOut.Target.setText(t);
	}

}

