package SOMA.network.connection;

/** Recapita un messaggio (stringa) e restituisce una conferma.
*
* @author Livio Profiri
*/
public class SendMessageCommand extends Command
{
  /** @serial*/
  String Message;
  /** @serial*/
  boolean Andata;

  public SendMessageCommand(String Message) {
    this.Message = Message;
    Andata = true;
  }

  /** Visualizza il messaggio e spedisce la conferma. */
  public void run()
  {
    // Questo comando  usato anche al di fuori del sistema ad agenti,
    // nel menu socket, dove env non  definito.
    (env != null ? env.out : System.out).println( "SendMessageCommand: Connection: " + ReturnConnection.toString() +
                                    "   Message: " + Message );
    Return( new QuickCommand()
      {
        public void run()
        {
          (env != null ? env.out : System.out).println( "[RECAPITATO: " + Message + "]" );
        }
      });
  }

  public String toString()
  {
    return "[" + Message + "]";
  }
}
