package SOMA.network.connection;

import SOMA.Environment;

/** <P>{@link SOMA.network.connection.Command Comando} che non viene eseguito da un thread separato per ragioni di efficienza.
* </P><P> QuickCommand va utilizzato sono per comandi di rapida esecuzione,
* che non corrono il rischio di bloccare il server impedendo ai comandi successivi di essere eseguiti.
* </P>
* @author Livio Profiri
*/

public abstract class QuickCommand extends Command
{
  /** Effettuate le inizializzazioni, chiama direttamente {@link #run()}.
  * <BR>
  * {@link #run()} deve poter essere eseguito tanto in fretta da rendere inefficiente la
  * creazione e l'avvio di un nuovo thread.
  */

  public void start( Connection ReturnConnection, Environment env )
  {
    this.ReturnConnection = ReturnConnection;
    this.env = env;

    // Non creo un altro thread, ma eseguo utilizzando quello attuale
    // Attenzione: run deve poter essere eseguita tanto in fretta da rendere pesante il lancio
    // di un nuovo thread.
    run();
  }
}