package SOMA.network.connection;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;
import SOMA.Environment;

/** Voce di menu che crea una nuova {@link SOMA.network.connection.Connection connessione}
* verso un {@link SOMA.network.connection.ConnectionServer server}.
* <BR>
* Per ogni connessione creata si aggiunge
* una nuova {@link SOMA.explorer.ExplorerItem voce}
* ad un {@link SOMA.explorer.DirExplorerItem menu}.
*
* @author Livio Profiri
*/
public class NewClientExplorerItem extends ExplorerItem
{
  /** @serial*/
  DirExplorerItem dir;
  /** @serial*/
  Environment env = null;   // Attenzione ai possibili errori!!!
  /** @serial*/
  int serialNumber;

  /** Costruttore.
  * @param dir Il menu a cui aggiungere le nuove {@link SOMA.explorer.ExplorerItem voci}.
  */
  public NewClientExplorerItem( DirExplorerItem dir )
  {
    super( "host port" );
    this.dir = dir;
    this.env = env;
    serialNumber = 1;
  }

  /** Metodo di esecuzione. Parametri richiesti: <B>host</B> <B>port</B>
  * del server.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 2 )
    {
      Iterator i = Parameters.iterator();
      String host = (String)i.next();
      String Param = (String)i.next();

      int port = 0;
      try
      {
        port = Integer.parseInt( Param );
      }
      catch( Exception e )
      {
        out.println( "ERROR: incorrect port number" + Param );
        return null;
      }

      String newItemName = "Client" + serialNumber++;

      try
      {
        ConnectionExplorerItem newConnectionItem =
          new ConnectionExplorerItem(
            new Connection( new java.net.Socket( host, port ), env ) );

        dir.addItem( newItemName, newConnectionItem );
        return newConnectionItem;
      }
      catch( Exception e )
      {
        e.printStackTrace( out );
      }
    }
    return null;
  }

  public String Help( PrintStream out )
  {
    String help = "host port: Creates a new client to the specified host:port.";

    out.println( help );

    return help;
  }
}