package SOMA.network.connection;

/** Interfaccia per la gestione di un demone generico.
* @see SOMA.network.connection.DaemonExplorerItem
* @author Livio Profiri
*/
public interface Daemon
{
  /** Avvio del demone. */
  public void start() throws Exception;
  /** Arresto del demone. */
  public void stop() throws Exception;
  /** Restutuisce lo stato del demone.
  * <BR>
  * Gli stati previsti da questa interfaccia sono {@link #ON}, {@link #OFF}
  * ed {@link #ERROR}. Se necessario le classi che implementano l'interfaccia ne aggiungeranno altri.
  */
  public Object getStatus();

  /** <P>Demone attivo.
  *
  * <P> Per lo stato di un daemon si usa un generiso Object in modo da non moltiplicare i nomi
  * e da aumentare la flessibilit.
  */
  public static final Object ON = new Status( "ON" );
  /** Demone disattivo. */
  public static final Object OFF = new Status( "OFF" );
  /** Demone in condizione di errore. */
  public static final Object ERROR = new Status( "ERROR" );
}