package SOMA.network;

import SOMA.naming.PlaceID;
import SOMA.network.connection.*;

/** Comando che avvia una connessione stabile fra place.
*
* @author Livio Profiri
*/
public class ConnectionCommand extends Command
{
  /** @serial*/
  PlaceID Source;

  /** Costruttore. */
  public ConnectionCommand( PlaceID Source )
  {
    this.Source = Source;
  }

  /** Salva nel {@link SOMA.network.NetworkManager#connectionStore connectionStore}
  * la connessione attuale.
  */
  public void run()
  {
    //env.out.println( "ConnectionCommand: CONNECTION: " + Source + " <--> " + env.placeID );
    env.networkManager.connectionStore.putConnection( Source, ReturnConnection );
  }
}
