package SOMA.naming.place;

import SOMA.naming.*;
import SOMA.network.connection.*;

/** 
 * Comando di eliminazione di un place da un {@link PlaceNameService PNS}.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class RemovePlaceCommand extends Command {
	
	PlaceID toRemove;
	
	/** Costruttore. */
	public RemovePlaceCommand(PlaceID toRemove)
	{
		this.toRemove = toRemove;
		System.out.println(toString() + " created ");
	}
	
	/** Rimuove il place. */
	public void run() {
		env.placeNameService.removePlace(toRemove);
		env.out.println(toString() + " Completed!");
	}
	
	public String toString() {
		return "[RemovePlaceCommand " + toRemove + "]";
	}
}
