package SOMA.naming.place;

import SOMA.network.connection.*;

/** 
 * Comando di aggiornamento di un PlaceNameService PNS.
 * Viene aggiunto o modificato un place.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class PutPlaceCommand extends Command {
	// Attenzione: funziona sia per place aggiunti, che per place modificati.
	
	PlaceInfo toPut;
	
	/** Costruttore. */
	public PutPlaceCommand(PlaceInfo toPut) {
		this.toPut = toPut;
		System.out.println(toString() + " created ");
	}
	
	/** Aggiunge o modifica il place. */
	public void run() {
		env.placeNameService.putPlace(toPut);
		env.out.println(toString() + " Completed!");
	}
	
	public String toString() {
		return "[PutPlaceCommand " + toPut + "]";
	}
	
}

