package SOMA.naming.place;

import SOMA.ext.PNSManagement.*;
import SOMA.network.connection.*;

/** 
 * Comando di registrazione del PlaceNameService PNS di un place presso il PNS del default place.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class PlaceRegisterCommand extends Command {
	
	protected PlaceInfo myPlaceInfo;
	
	/** Costruttore. */
	public PlaceRegisterCommand(PlaceInfo myPlaceInfo) {
		this.myPlaceInfo = myPlaceInfo;
		System.out.println("Register command " + myPlaceInfo + " created!");
	}
	
	/** 
	 * Registra il place e gli spedisce un PlaceRefreshCommand.
	 * Se un place con lo stesso nome era gia' presente, gli viene spedito un messaggio di errore.
	 */
	public void run() {
		env.out.println("Register command " + myPlaceInfo + " running...");
		// Verifico che non sia gi presente il nome e che sia nello stesso dominio!
		if(myPlaceInfo.placeID.sameDomain(env.placeID) && env.placeNameService.getPlace(myPlaceInfo.placeID) == null) {
			env.placeNameService.putPlace(myPlaceInfo);
			env.networkManager.connectionStore.putConnection(myPlaceInfo.placeID,ReturnConnection);
			Return(new PlaceRefreshCommand(env));
			// Invio aggiornamento allo slave
			try {
				if(env.repConnection != null) {
					env.repConnection.send(new SlavePNSRefreshCommand(myPlaceInfo));
				}
			}
			catch(Exception e) {
				e.printStackTrace();
			}
		}
		else {
			Return(new Command() {
				public void run() {
					env.err.println("ERROR: Can't register place " + myPlaceInfo);
					try {
						ReturnConnection.stop();
					}
					catch( Exception f ) {
						f.printStackTrace(env.err);
					}
				}
			});
			env.err.println("ERROR: Place " + myPlaceInfo + " already exists!");
		}
	}
	
}