package SOMA.naming.place;

import java.net.*;
import SOMA.naming.*;

/** 
 * Memorizza informazioni relative ad un place.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */

public class PlaceInfo implements java.io.Serializable {
	
	// L'oggetto  sempre costante a meno della connessione: ricrearne uno nuovo per cambiarne propriet.
	/** Identificatore del place. */
	public final PlaceID placeID;
	/** Indirizzo del ConnectionServer del place. */
	public final InetAddress host;
	/** Porta del ConnectionServer del place. */
	public final int port;
	
	public PlaceInfo(PlaceID placeID,InetAddress host,int port) {
		this.placeID = placeID;
		this.host = host;
		this.port = port;
	}
	
	public String toString() {
		return "[" + placeID + "-->" + host + " : " + port + "]";
	}
	
	public boolean equals(Object obj) {
		if(!(obj instanceof PlaceInfo)) {
			return false;
		}
		else {
			PlaceInfo p = (PlaceInfo)obj;
			return placeID.equals(p.placeID) && host.equals(p.host) && port == p.port;
		}
	}
	
}