package SOMA.naming.place;

import java.util.*;
import java.io.*;
import java.net.*;

import SOMA.explorer.*;
import SOMA.naming.*;

/** Voce di menu per la gestione di un {@link PlaceNameService PNS}.
* @author Livio Profiri
*/
public class PNSExplorerItem extends ExplorerItem
{
  /** @serial*/
  PlaceNameService pns;

  /** Costruttore. */
  public PNSExplorerItem( PlaceNameService pns )
  {
    this.pns = pns;
    Syntax = "{list | put <place> <host> <port> | del <place> | register <host> <port> | refresh {<host> <port>} }";
  }

  /** Effettua tutte le possibili operazioni su un PNS.
  * <P>
  * Le opzioni sono:<BR>
  * {list | put "place" "host" "port" | del "place" | register "host" "port" | refresh {"host" "port"} }
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    try
    {
      Iterator i = Parameters.iterator();

      if( !i.hasNext() )
        return Help();

      String Param = (String)i.next();

      if( Param.equals( "list" ) )
      {
        pns.listPlaces( out );
        return pns.places;
      }
      else if( Param.equals( "put" ) )
      {
        String place = (String)i.next();
        String host = (String)i.next();
        String portString = (String)i.next();

        try
        {
          int port = Integer.parseInt( portString );
          PlaceInfo newPI = new PlaceInfo( new PlaceID( place, "" ),
                                          InetAddress.getByName( host ),
                                          port );
          PlaceInfo oldPI = pns.putPlaceSlave( newPI );
          out.println( "  Old Place: " + oldPI );
          out.println( "  New Place:" + newPI );

          return oldPI;
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "del" ) )
      {
        try
        {
          PlaceID aPlaceID = new PlaceID( (String)i.next() );
          PlaceInfo oldPI = pns.removePlaceSlave( aPlaceID );

          out.println( "  Place " + oldPI + " REMOVED" );
          return oldPI;
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "register" ) )
      {
        String host = (String)i.next();
        String portString = (String)i.next();

        try
        {
          if( pns.register( InetAddress.getByName( host ), Integer.parseInt( portString ) ) )
            out.println( "  Registration COMPLETED!" );
          else
            out.println( "  Registration FAILED!" );
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
        }
        return null;
      }
      else if( Param.equals( "refresh" ) )
      {
        if( i.hasNext() )
        {
          String host = (String)i.next();
          String portString = (String)i.next();

          try
          {
            if( pns.refresh( InetAddress.getByName( host ), Integer.parseInt( portString ) ) )
              out.println( "  Refresh REQUESTED" );
            else
              out.println( "  Refresh FAILED!" );
          }
          catch( UnknownHostException e )
          {
            e.printStackTrace( out );
            return null;
          }
        }
        else
        {
          if( pns.refresh() )
            out.println( "  Refresh REQUESTED" );
          else
            out.println( "  Refresh FAILED!" );
        }

        return null;
      }
    }
    catch( NoSuchElementException e )
    {
      out.println( "Wrong number of parameters" );
    }
    return null;
  }
}