package SOMA.naming.domain;

import SOMA.ext.DNSManagement.*;
import SOMA.naming.*;
import SOMA.network.connection.*;

/** Comando di eliminazione di un dominio da un {@link DomainNameService DNS}.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class RemoveDomainCommand extends Command {
	
	PlaceID toRemove;
	
	/** Costruttore. */
	public RemoveDomainCommand(PlaceID toRemove) {
		this.toRemove = toRemove;
		System.out.println( toString() + " created " );
	}
	
	/** Rimuove il dominio. */
	public void run() {
		env.domainNameService.removeDomain(toRemove);
		// Invio aggiornamento allo slave
		if(env.repConnection != null && env.repConnection.getStatus() == Daemon.ON) {
			try {
				if(env.repConnection != null && env.repConnection.getStatus() == Daemon.ON) {
					env.repConnection.send(new SlaveDNSRemoveCommand(toRemove));
				}
			}
			catch(Exception e) {
				e.printStackTrace(env.err);
			}
		}
		env.out.println(toString() + " Completed!");
	}
	
	public String toString() {
		return "[RemoveDomainCommand " + toRemove + "]";
	}
	
}
