package SOMA.naming.domain;

import SOMA.ext.DNSManagement.*;
import SOMA.network.connection.*;

/** 
 * Comando di aggiornamento di un {@link DomainNameService DNS}.
 * Viene aggiunto o modificato un dominio.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class PutDomainCommand extends Command {
	// Attenzione: funziona sia per domain aggiunti, che per domain modificati.

	DomainInfo toPut;
	
	/** Costruttore. */
	public PutDomainCommand(DomainInfo toPut) {
		this.toPut = toPut;
		System.out.println(toString() + " created ");
	}
	
	/** Aggiunge o modifica il dominio. */
	public void run() {
		env.domainNameService.putDomain(toPut);
		try {
			ReturnConnection.stop();
			// Invio aggiornamento allo slave
			if(env.repConnection != null && env.repConnection.getStatus() == Daemon.ON) {
				env.repConnection.send(new SlaveDNSTableRefreshCommand(toPut));
			}
		}
		catch(Exception e) {
			e.printStackTrace(env.err);
		}
		env.out.println(toString() + " Completed!");
	}
	
	public String toString() {
		return "[PutDomainCommand " + toPut + "]";
	}

}