package SOMA.naming.domain;

import SOMA.ext.DNSManagement.*;
import SOMA.network.connection.Command;

/** 
 * Comando di registrazione di un DomainNameService DNS presso una altro DNS che diventera' il padre.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class DomainRegisterCommand extends Command {
	
	DomainInfo myDomainInfo;
	
	/** Costruttore. */
	public DomainRegisterCommand(DomainInfo myDomainInfo) {
		this.myDomainInfo = myDomainInfo;
		System.out.println("Register command " + myDomainInfo + " created!");
	}
	
	/** 
	 * Registra il dominio e gli spedisce un DomainRefreshCommand.
	 * Se un dominio con lo stesso nome era gia' presente, gli viene spedito un messaggio di errore.
	 */
	public void run() {
		env.out.println("Register command " + myDomainInfo + " running...");
		// Attenzione: la registrazione  immediata e non passa attraverso la gerarchia per se ci sono nomi doppi il dominio rischia di rimanere escluso!
		// Verifico che non sia gi presente il nome!
		if(env.domainNameService.getDomain(myDomainInfo.placeID) == null) {
			env.domainNameService.putDomain(myDomainInfo);
			env.domainNameService.childrenDNS.add(myDomainInfo.placeID);
			Return(new DomainRefreshCommand(env,true));
			// Invio aggiornamento allo slave
			try {
				if(env.repConnection != null) env.repConnection.send(new SlaveDNSChildRefreshCommand(myDomainInfo));
			}
			catch(Exception e) {
				e.printStackTrace();
			}
		}
		else {
			Return(new Command() {
				public void run() {
					env.err.println("ERROR: Domain " + myDomainInfo + " already exists!");
					try {
						ReturnConnection.stop();
					}
					catch(Exception f) {
						f.printStackTrace(env.err);
					}
				}
			});
			env.err.println("ERROR: Domain " + myDomainInfo + " already exists!");
		}
	}
	
}