package SOMA.naming.domain;

import SOMA.ext.DNSManagement.*;
import SOMA.naming.*;
import SOMA.network.connection.Command;
import SOMA.Environment;
import java.util.Hashtable;

/** 
 * Comando di aggiornamento della tabella dei domini di un {@link DomainNameService DNS}.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class DomainRefreshCommand extends Command {
	
	PlaceID fatherDomainID;
	DomainInfo fatherDomainInfo;
	Hashtable domains;
	boolean closeConnection;
	static boolean request = false;
	
	/** Costruttore. */
	public DomainRefreshCommand(Environment env) {
		this(env,false);
	}
	
	/** Costruttore. */
	public DomainRefreshCommand(Environment env,boolean closeConnection) {
		this.fatherDomainID = env.placeID;
		this.fatherDomainInfo = (DomainInfo)env.networkManager.placeInfo;
		this.domains = env.domainNameService.domains;
		this.closeConnection = closeConnection;
		System.out.println(toString() + " (" + domains.size() + " domains) created." );
	}
	
	/** Aggiorna la tabella e spedisce l'aggiornamento ai figli. */
	public void run() {
		env.domainNameService.fatherDNS = fatherDomainID;
		env.domainNameService.domains = domains;
		if(closeConnection) {
			try {
				ReturnConnection.stop();
			}
			catch(Exception e) {
				e.printStackTrace(env.err);
			}
		}
		env.domainNameService.sendToChildrenDomains(new DomainRefreshCommand(env));
		// Invio aggiornamento allo slave
		if(!request) {
			try {
				if(env.repConnection != null) env.repConnection.send(new SlaveDNSFatherRefreshCommand(fatherDomainInfo,env.domainNameService.domains));
			}
			catch(Exception e) {
				e.printStackTrace();
			}
		}
		env.out.println(toString() + " completed (" + domains.size() + " domains) !!!");
		request = false;
	}
	
	public String toString() {
		return "[RefreshCommand from " + fatherDomainID + " disconnect: " + closeConnection + "]";
	}
	
	// Questa classe  stata messa qui per non moltiplicare il numero di file
	// del package e perch  una classe di supporto per l'altra.
	/** 
	 * Comando di richiesta di refresh della tabella dei domini.
	 *
	 * @author Livio Profiri
	 * Revised by Alessandro Ghigi
	 */
	public static class Request extends Command {
		
		boolean closeConnection = false; 
		
		public Request() {}
		
		public Request(boolean closeConnection) {
			this.closeConnection = closeConnection;
		}
		
		/** Viene spedito un DomainRefreshCommand con la nuova tabella. */
		public void run() {
			request = true;
			Return(new DomainRefreshCommand(env,closeConnection));
		}
		
	}

}
