package SOMA.naming.domain;

import java.net.*;
import SOMA.naming.*;
import SOMA.naming.place.*;
/** Memorizza informazioni relative ad un dominio.
* Le informazioni memorizzate sono le stesse di un PlaceInfo,
* quindi non sono stati aggiunti campi. L'unico vincolo in piu' e' che
* placeID deve rappresentare l'identificatore di un default place.
* Questo controllo viene effettuato dai due costruttori.
*
* @author Livio Profiri
* Revised by Alessandro Ghigi
*/

public class DomainInfo extends PlaceInfo {
	
	public DomainInfo(PlaceID domainID,InetAddress host,int port) throws NameException {
		super(domainID,host,port);
		// Non creo l'istanza se si tratta dell'ID di un place
		if(!domainID.isDomain()) throw(new NameException("PlaceID " + domainID + " is not a domain ID"));
	}
	
	/** Costruttore: copia tutti i campi di placeInfo. */
	public DomainInfo(PlaceInfo pi) throws NameException {
		super(pi.placeID,pi.host,pi.port);
		// Non creo l'istanza se si tratta dell'ID di un place
		if(! placeID.isDomain()) throw(new NameException("PlaceID " + placeID + " is not a domain ID"));
	}
	
}