package SOMA.naming;
import java.util.*;

/** Identificatore di un place.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class PlaceID implements java.io.Serializable {
	
	/** Dominio di appartenenza. */
	public final String domain;
	/** Nome del place, unico nell'ambito dello stesso dominio. */
	public final String place;
	
	/** Costruisce un identificatore a partire dalle sue componenti. */
	public PlaceID(String domain,String place) {
		this.domain = domain;
		this.place = place;
	}
	
	/** Costruisce un identificatore a partire da una stringa. */
	public PlaceID(String s) throws NameException {
		java.util.StringTokenizer stok  = new java.util.StringTokenizer(s);
		if(stok.hasMoreTokens()) domain = stok.nextToken();
		else throw new NameException("Empty Place Name string");
		if(stok.hasMoreTokens()) place = stok.nextToken();
		else place = "";
		if(stok.hasMoreTokens()) throw new NameException("Place Name has more than two tokens");
	}
	
	/** Restituisce true se l'identificatore rappresenta un default place.
	 * L'identificatore di un default place ha il campo place uguale a "".
	 * In altre parole viene specificato solo il dominio.
	 */
	public boolean isDomain() {
		return place.equals("");
	}
	
	/** Restituisce true se other e' un place dello stesso dominio. */
	public boolean sameDomain(PlaceID other) {
		return this.domain.equals(other.domain);
	}
	
	/** Restituisce l'identificatore del default place dello stesso dominio. */
	public PlaceID getDomainID() {
		return new PlaceID(domain,"");
	}
	
	/** Restituisce il PlaceID stesso. */
	public PlaceID getHome() {
		return this;
	}
	
	/** 
	 * Rappresentazione dell'identificatore sotto forma di stringa.
	 * E' l'inversa di PlaceID(String s).
	 */
	public String toString() {
		return domain + " " + place;
	}
	
	public boolean equals(Object obj) {
		if(!(obj instanceof PlaceID)) return false;
		else {
			PlaceID p = (PlaceID) obj;
			return domain.equals(p.domain) && place.equals(p.place);
		}
	}
	
	public boolean isSlave() {
		StringTokenizer st = new StringTokenizer(this.domain,"_");
		if(st.countTokens() == 2) {
			String tok1 = st.nextToken();
			String tok2 = st.nextToken();
			if(tok2.equals("S")) return true;
		}
		return false;
	}
	
	public int hashCode() {
		return (domain + place).hashCode();
	}
	
	public Object clone() {
		return new PlaceID(domain,place);
	}
	
}