package SOMA.naming;


import iaik.x509.X509Certificate;
import java.io.*;

import SOMA.security.*;
import SOMA.security.infrastructure.*;
import SOMA.agent.classLoading.ClassManager;

/** Identificatore di un {@link SOMA.agent.Agent agente}.
*
* @author Luca Ghetti
*/
//Attualmente in CodeAgentSignature, StateAgentSignature che sono oggetti pkcs7 c'e' sia la fimra anche il dato
//originale. occorre invece estrarre dal risultato di signedData solo la firma, e quindi
//in ProfileManager occorre aggiungere un metodo di estrazione parte di firma da pkcs7StateAgentSignature. Quando
//verr aggiustato il tutto, occorre assolutamente togliere l'equal tra i due bytecode
public class AgentIDSigned extends AgentID implements java.io.Serializable
{
  /** Numero di serie dell'agente, unico nell'ambito di un place.
  * @serial

  public final int ID;
 */
 /**
  * Identificatore del place in cui l'agente e' stato creato.
  * @serial
  public final PlaceID place;
*/
  public X509Certificate x509 = null;

  public byte [] CodeAgentSignature = null;

  public byte [] StateAgentSignature = null;

  //public AgentIDSigned  ()
  //{
  //super();
  //}

  AgentIDSigned  (PlaceID place, int ID, X509Certificate x509, byte [] CodeAgentSignature, byte [] StateAgentSignature)
  {
    super ( place , ID );
    this.x509 = x509;
    this.CodeAgentSignature = CodeAgentSignature;
    this.StateAgentSignature = StateAgentSignature;
  }

  /** Costruisce un identificatore a partire dalle sue componenti.*/
  public AgentIDSigned (PlaceID place, int ID)
  {
      super ( place , ID );
  }

  /** Costruisce un identificatore a partire da una stringa.
  * <BR> E' l'inversa di {@link #toString()}.
  */
  public AgentIDSigned ( String s ) throws NameException, NumberFormatException
  {
    super(s);
  }


  public boolean equals(Object obj)
  {
    if( !(obj instanceof AgentIDSigned) )
    {
      return false;
    }
    else
    {
      AgentIDSigned a = (AgentIDSigned) obj;
      return place.equals( a.place ) &&
             ID == a.ID &&
             x509 == a.x509;
    }
  }

  public  X509Certificate getCertificate()
  {
    return this.x509;
  }

  public Object clone()
  {
    return new AgentIDSigned((PlaceID)place.clone(),ID, x509, CodeAgentSignature, StateAgentSignature);
  }


  public final boolean signatureCode ( ProfileManager profile, String agentName )
  {
    byte [] classToSign;

    try {
      ClassManager agentClassManager = new ClassManager( System.getProperty( "user.dir" ) + File.separator + "agents", false );
      ClassManager cacheClassManager = new ClassManager( System.getProperty( "user.dir" ) + File.separator + "cache", false );

      if ( agentClassManager == null || (classToSign = agentClassManager.loadClassFile(agentName)) == null)
        if( cacheClassManager == null || (classToSign = cacheClassManager.loadClassFile(agentName)) == null)
           return false;

      x509 = profile.getProfile().getSigningCertificate();

      //System.out.println("\n    x509 : " + x509.toString() );
      CodeAgentSignature = profile.signedData( classToSign );
      //System.out.println("   CodeAgentSignature : " + new String(CodeAgentSignature) + "\n" );



      return ( (CodeAgentSignature) != null );
    } catch ( Exception e ) { System.out.println(" Errore: " + e ); }

    return false;
  }



  public final boolean verifyCode ( SecurityEnvironment env, String agentName )
  {
    byte [] classToSign;
    OutputStream out = new ByteArrayOutputStream();
    ByteArrayOutputStream ba = new ByteArrayOutputStream();

    System.out.println("\n   Inside verify code" );

    try {
      if ( x509 == null || CodeAgentSignature == null ) return false;

      /**
        * Questo codice serve se nella firma non  presente il codice della classe
      ClassManager agentClassManager = new ClassManager( System.getProperty( "user.dir" ) + File.separator + "agents", false );
      ClassManager cacheClassManager = new ClassManager( System.getProperty( "user.dir" ) + File.separator + "cache", false );


      if ( agentClassManager == null || (classToSign = agentClassManager.loadClassFile(agentName)) == null)
        if( cacheClassManager == null || (classToSign = cacheClassManager.loadClassFile(agentName)) == null)
           return false;
      **/

       return ( env.profile.verifySignedData( CodeAgentSignature, x509 ));
               // (ba.write ( classToSign ).equal(out) ));

    } catch ( Exception e ) { env.out.println(" Errore: " + e ); }

    return false;
  }

  public final boolean verifyCode ( SecurityEnvironment env, String agentName, byte[] classData )
  {
    byte [] classToSign;
    OutputStream out = new ByteArrayOutputStream();
    OutputStream ba = new ByteArrayOutputStream();

    try {
      if ( x509 == null || CodeAgentSignature == null || classData == null ) return false;


       return (env.profile.verifySignedData( CodeAgentSignature, x509 ));
                //((ba.write ( classData ).equal(out) ));

    } catch ( Exception e ) { env.out.println(" Errore: " + e ); }

    return false;
  }

  public final boolean signatureState ( ProfileManager profile )
  {
    String stateToSign;


    try {
      //modifica di rebecca al 19 novembre
      //if ( place == null || (stateToSign = (place.toString() + ID).toString().getBytes()) == null ) return false;
      //if ( place == null || (stateToSign = this.toString().getBytes()) == null ) return false;
      if ( place == null || (stateToSign = this.toString()) == null ) return false;

      x509 = profile.getProfile().getSigningCertificate();
      StateAgentSignature = profile.signedData(stateToSign.getBytes());

      //System.out.println("   StateAgentSignature : " + new String(StateAgentSignature) + "\n" );

      return ((StateAgentSignature) != null );
    } catch ( Exception e ) { System.out.println(" Errore: " + e ); }

    return false;
  }


  public final boolean verifyState ( SecurityEnvironment env )
  {

    try {
      if ( x509 == null || StateAgentSignature == null ) return false;

        return (env.profile.verifySignedData( StateAgentSignature, x509 ));

    } catch ( Exception e ) { env.out.println(" Errore: " + e ); }

    return false;

  }


}

