package SOMA.naming;

import SOMA.mobilePlace.MobilePlaceID;

/** Identificatore di un {@link SOMA.agent.Agent agente}.
*
* @author Livio Profiri
*/
public class AgentID implements java.io.Serializable
{
  /** Numero di serie dell'agente, unico nell'ambito di un place.
  * @serial
  */
  public final int ID;

  /**
  * Identificatore del place in cui l'agente e' stato creato.
  * @serial*/
  public final PlaceID place;



  /** Costruisce un identificatore a partire dalle sue componenti. */
  public AgentID (PlaceID place, int ID)
  {
      this.ID = ID;
      this.place = place;
  }

  /** Costruisce un identificatore a partire da una stringa.
  * <BR> E' l'inversa di {@link #toString()}.
  */
  public AgentID ( String s ) throws NameException, NumberFormatException
  {
    // Vedo se c' il prefisso.
    boolean isMobilePlaceID = MobilePlaceID.isMobile( s );

    //Questo serve per eliminare l'eventuale prefisso che segnala che un place  mobile.
    //  Restituisce la stringa senza prefisso.
    s = SOMA.mobilePlace.MobilePlaceID.removePrefix( s );

    java.util.StringTokenizer stok  = new java.util.StringTokenizer( s );

    if( stok.countTokens() == 2 )
    {
      place = new PlaceID( stok.nextToken(), "" );
      ID = Integer.parseInt( stok.nextToken() );
    }
    else if( stok.countTokens() == 3 )
    {
      if( isMobilePlaceID )
        place = new MobilePlaceID( stok.nextToken(), stok.nextToken() );
      else
        place = new PlaceID( stok.nextToken(), stok.nextToken() );

      ID = Integer.parseInt( stok.nextToken() );
    }
    else
      throw new NameException( "Invalid Agent Name" );
  }

  /** Restituisce il place cui spedire le informazioni sulla posizione dell'agente.
  * <BR> Questo metodo viene ridefinito dalla classe MobileAgentID.
  */
  public PlaceID getHome()
  {
    return place.getHome();
  }

  /** Rappresentazione dell'identificatore sotto forma di stringa.
  * <BR> E' l'inversa di {@link #AgentID( String s ) AgentID( String s )}.
  */
  public String toString()
  {
    return place.toString() + " " + ID;
  }

  public boolean equals(Object obj)
  {
    if( !(obj instanceof AgentID) )
    {
      return false;
    }
    else
    {
      AgentID a = (AgentID) obj;
      return place.equals( a.place ) &&
             ID == a.ID;
    }
  }

  public int hashCode()
  {
    return place.hashCode() ^ ID;
  }

  public Object clone()
  {
    return new AgentID((PlaceID)place.clone(),ID);
  }
}

