package SOMA.mobilePlace;

import java.util.*;
import java.net.InetAddress;
import SOMA.naming.place.*;

/** Servizio di nomi di place mobile, <B>PNS</B>.
*
*
* @see SOMA.naming.place.PlaceNameService
* @see SOMA.naming.domain.DomainNameService
*
* @author Livio Profiri
*/

public class MobilePlaceNameService extends PlaceNameService
{
  /** Costruttore.
  * @param env L'environment del place.
  */
  public MobilePlaceNameService( SOMA.Environment env )
  {
    super( env );
  }

  /** Registrazione presso il PNS del default place del dominio.
  *
  * <P>Viene inviato un {@link PlaceRegisterCommand} al default place, individuato dalla coppia
  * <B>host:port</B>.
  */
  public boolean register( InetAddress host, int port )
  {
    boolean answer = env.networkManager.sendCommand( host, port,
      new MobilePlaceRegisterCommand( env.networkManager.placeInfo ) );

    //env.domainNameService.refresh( host, port );

    return answer;
  }

  /** Elimina tutti i place tranne il place mobile. */
  public void clear()
  {
    places = new Hashtable();

    putPlace( env.networkManager.placeInfo );
  }

  public String toString()
  {
    return "[mobile " + super.toString() + "]";
  }
}