package SOMA.mobilePlace;

import SOMA.naming.*;
import SOMA.network.connection.Command;

/** Comando di registrazione del {@link MobilePlaceNameService PNS} di un place mobile presso il PNS del default place.
*
* @author Livio Profiri
*/
public class MobilePlaceDisconnectionCommand extends Command
{
  PlaceID myPlaceID;

  /** Costruttore */
  public MobilePlaceDisconnectionCommand( PlaceID myPlaceID )
  {
    this.myPlaceID = myPlaceID;
  }

  public void run()
  {
    // Mancano i Controlli di sicurezza!!!

    // Aggiorno la posizione del place mobile sulla home
    env.networkManager.sendCommand( ((MobilePlaceID)(myPlaceID)).getHome(),
        new MobilePlaceConnectionCommand.UpdateHomePositionCommand(
           myPlaceID,
           MobilePlaceManager.DISCONNECTED ) );

    env.placeNameService.removePlace( myPlaceID );
  }
}