/**  MessDelLancia
 *     Messaggio DAL "DelegatePlace" VERSO L'"AcceptPlace" per il LANCIO di un agente.
 *     @autore     Luigi Antenucci
 *     @versione   1.0
 *     @linguaggio jdk 1.2.2
 */

package SOMA.gui.remotegui;


public class MessDelLancia extends MessDel {

      /**
       *  Contenuto informativo del messaggio (i dati).
       *  Sono pubblici: li faccio modificabili per non dover costruire un
       *  eccessivo numero di metodi di lettura modificabili ("oggetto come valore").
       */
  public String nomeAgente;
  public String[] arrParam;
  public boolean usaSysClassLoader;
  public boolean rintracciabile;
  public boolean nonFarloPartire;

      /**
       *  Creazione del messaggio.
       */
  public MessDelLancia (String nomeAgente, String[] arrParam,
                        boolean usaSysClassLoader, boolean rintracciabile, 
                        boolean nonFarloPartire) {
    this.nomeAgente = nomeAgente;
    this.arrParam   = arrParam;
    this.usaSysClassLoader = usaSysClassLoader;
    this.rintracciabile    = rintracciabile;
    this.nonFarloPartire   = nonFarloPartire;
  } //costruttore

      /**
       *  Visualizzazione in stringa del messaggio.
       */
  public String toString () {
    String S = getClass().getName()+ "< "+nomeAgente+"(";
    int L = arrParam.length;
    for (int i=0; i<L; i++) {
      S = S + arrParam[i];
      if (i < (L-1))
        S = S + ",";
    } //for
    S = S + ") ";
    if (usaSysClassLoader) S = S + "SysCL ";
    if (! rintracciabile)  S = S + "NoTrace ";
    if (nonFarloPartire)   S = S + "NoRun ";
    S = S + ">";
    return S;
  } //toString

} //MessDelLancia