/**  GigiIconFactory
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2
 */

package SOMA.gui.gigi;

import java.io.File;
import java.io.Serializable;
import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;


public class GigiIconFactory implements Serializable {

      /**
       *  Percorso per ritrovare le immagini usate da questo "look & feel"
       */
  public static final  String GIGI_PIC_PATH = "SOMA"+File.separator+"gui"+File.separator+"gigi"+File.separator+"picture"+File.separator;

  private static Icon radioButtonIcon = null;
  private static Icon checkBoxIcon    = null;

      /**
       *  Accesso alla singola istanza del radio-button.
       */
  public static Icon getRadioButtonIcon () {
    if (radioButtonIcon == null) {
      radioButtonIcon = new RadioButtonIcon();
    }
    return radioButtonIcon;
  } //getRadioButtonIcon

      /**
       *  Accesso alla singola istanza del check-box.
       */
  public static Icon getCheckBoxIcon () {
    if (checkBoxIcon == null) {
      checkBoxIcon = new CheckBoxIcon();
    }
    return checkBoxIcon;
  } //getCheckBoxIcon


      /**
       *  CLASSE INTERNA PER L'ICONA DI UN RADIO-BUTTON
       *  NB: DEVE implementare l'"UIResource"!
       */
  private static class RadioButtonIcon implements Icon, UIResource, Serializable {

    private static ImageIcon iconaOn  = new ImageIcon (GIGI_PIC_PATH+"RadioOn.gif");
    private static ImageIcon iconaOff = new ImageIcon (GIGI_PIC_PATH+"RadioOff.gif");
    private static ImageIcon iconaPre = new ImageIcon (GIGI_PIC_PATH+"RadioPre.gif");


    public int getIconWidth () { return iconaOn.getIconWidth (); }
    public int getIconHeight() { return iconaOn.getIconHeight(); }

    public void paintIcon (Component c, Graphics g, int x, int y) {
      // Prendo il bottone e il modello del componente che sto per visualizzare
      AbstractButton bottone = (AbstractButton) c;
      ButtonModel modello = bottone.getModel();
      if (modello.isPressed())
        iconaPre.paintIcon (c, g, x, y);
      else
        if (modello.isSelected())
          iconaOn.paintIcon (c, g, x, y);
        else
          iconaOff.paintIcon(c, g, x, y);
    } //paintIcon

  } //RadioButtonIcon

      /**
       *  CLASSE INTERNA PER L'ICONA DI UN CHECK-BOX
       *  NB: DEVE implementare l'"UIResource"!
       */
  private static class CheckBoxIcon implements Icon, UIResource, Serializable {

    private static ImageIcon iconaOn  = new ImageIcon (GIGI_PIC_PATH+"CheckOn.gif");
    private static ImageIcon iconaOff = new ImageIcon (GIGI_PIC_PATH+"CheckOff.gif");
    private static ImageIcon iconaPre = new ImageIcon (GIGI_PIC_PATH+"CheckPre.gif");


    public int getIconWidth () { return iconaOn.getIconWidth (); }
    public int getIconHeight() { return iconaOn.getIconHeight(); }

    public void paintIcon (Component c, Graphics g, int x, int y) {
      // Prendo il bottone e il modello del componente che sto per visualizzare
      AbstractButton bottone = (AbstractButton) c;
      ButtonModel modello = bottone.getModel();

      // Traccio il bottone in base al suo stato (selezionato o meno):
      if (modello.isPressed())
        iconaPre.paintIcon (c, g, x, y);
      else
        if (modello.isSelected())
          iconaOn.paintIcon (c, g, x, y);
        else
          iconaOff.paintIcon(c, g, x, y);
    } //paintIcon

  } //CheckBoxIcon

} //GigiIconFactory