package SOMA.gui._theAgent;

/**  TheAgent - versione riveduta, corretta e ampliata dell'agente "Shell".
 *     Anzich stampare tutto sulla "text-area" di output si usano
 *     delle specifiche finestre (messe a disposizione dal pacchetto "gui").
 *     L'uso dell'I/O  stato ridotto al massimo!
 *     @author     Luigi Antenucci
 *     @version    3.33
 *     @language   jdk 1.2.2
 */


import SOMA.gui.*;
import SOMA.gui.lingua.*;
import SOMA.Environment;
import SOMA.explorer.ExplorerThread;
import SOMA.agent.*;
import SOMA.naming.*;
import SOMA.utility.*;
import SOMA.mobilePlace.*;

import java.io.File;
import java.util.Vector;
import java.util.Hashtable;
import java.net.InetAddress;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;


public class TheAgent extends Agent implements LinguaListener,
                                             PropertyChangeListener,
                                             FinGoto1000Listener,
                                             FinAgentMessageListener {
      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String COMANDO_AGENTID   = "agID";
  protected static final  String COMANDO_GOPLACE   = "goTo";
  protected static final  String COMANDO_IDLE      = "Idle";
  protected static final  String COMANDO_CHECK     = "mChk";
  protected static final  String COMANDO_SEND      = "mSnd";
  protected static final  String COMANDO_PLACEID   = "plID";
  protected static final  String COMANDO_PLACES    = "lstP";
  protected static final  String COMANDO_DOMAINS   = "lstD";
  protected static final  String COMANDO_GETENV    = "env";
  protected static final  String COMANDO_ADMIN     = "adm";
  protected static final  String COMANDO_HISTORY   = "his";
  protected static final  String COMANDO_VISITED   = "vis";
  protected static final  String COMANDO_GOTO_VIS  = "goVs";
  protected static final  String COMANDO_GOTO_HOME = "goHm";
  protected static final  String COMANDO_LOCHOST   = "idIP";
  protected static final  String COMANDO_MEMORY    = "Mmry";

  // VARIABILI NON SERIALIZZATE:
      /**
       *  Finestra di output dell'agente (non serializzabile).
       *  Si usa la seconda versione di OutputFrame - quella aggiornata da Gigi.
       */
  protected transient OutputFrame2 winOutFrame;

      /**
       *  Componenti aggiuntivi che "estendono" le funzionalit di "OutputFrame2".
       */
  protected transient JButton botAgID, botPlID,
                              botGoto, botSend,
                              botGoVi, botGoHo;

      /**
       *  Thread per l'esplorazione del men a linea di comando (non serializzabile).
       */
  protected transient ExplorerThread explorerThread = null;

      /**
       *  Il threadgroup corrente dell'agente (non serializzabile).
       */
  protected transient ThreadGroup threadGroup    = null;

      /**
       *  "Semaforo" su cui attendere prima di uscire.
       *  Serve per sincronizzare il thread principale (che aspetta) con il JMenu.
       */
  protected transient WaitAndTimeout exitSemaphore;

  // VARIABILI SERIALIZZATE:
      /**
       *  Il "chronometer", per calcolare il tempo impiegato per la migrazione
       *  tra un Place e l'altro.
       */
  protected Chronometer chronometer = new Chronometer();

      /**
       *  Testo della finestra di output. Quando si "migra" ci si porta dietro
       *  il testo, in modo da ricostruire (all'arrivo) una nuova finestra ma
       *  con il precedente testo.
       */
  protected String outputText;

      /**
       *  Elenco di tutti i Place visitati.
       *  Questa struttura cresce di un elemento a ogni migrazione!
       */
  protected Vector placeVisitati;

      /**
       *  Elenco della storia passata: contiene uno dopo l'altro tutti i Place
       *  su cui l'agente  passato.
       *  Questa struttura cresce di un elemento a ogni migrazione!
       */
  protected Vector placeStorici;

      /**
       *  Tabella delle frasi di lingua.
       *  Questa funzionalit e messa a disposizione dalla classe "Lingua" di SOMA.
       *  Sul nodo di creazione dell'agente (e solo su esso) l'utente pu scegliere
       *  la lingua da far usare all'agente nella stampa delle frasi.
       *  Quando l'agente migra, si porter dietro tutte le frasi (dell'ultima lingua
       *  scelta) in questa tabella.
       *  Sugli altri Place NON si deve permettere il cambio di lingua perch l'agente
       *  non ha provveduto a portarsi dietro tutti i file di lingua.
       */
  protected Hashtable tabellaLingua;  // Frasi di lingua

      /**
       *  File di lingua dell'agente (che risiede IMMOBILE sul Place di origine).
       *  Sebbene l'agente  mobile (qual piuma al vento), i file di lingua NON sono MOBILI.
       *  L'agente si porter dietro (al suo interno) tutte le stringhe di UNA SOLA LINGUA!
       *  Solo sul place di creazione potr accedere agli altri file di lingua!
       */
  protected String fileDiLingua;

      /**
       *  Qui ci metto il PlaceID a cui dovrei trovarmi dopo un'azione di "GOTO".
       *  Nello "startMethod" controllo che il Place attuale sia effettivamente questo qui.
       *  Se non lo , significa che l'azione di GO NON HA AVUTO PIENO SUCCESSO: dal Place
       *  precedente si  migrati a un Place che non  quello a cui si voleva andare, poich
       *  la migrazione si  INTERROTTA AL PLACE DI DEFAULT DEL DOMINIO IN CUI SI ERA.
       */
  protected PlaceID placeSuCuiMigrare;

      /**
       *  Metodo di partenza dell'agente all'atto della creazione.
       *  Definisce e inizializza tutti gli oggetti usati e alla fine chiama "startMethod".
       */
  public void run () {
    agentSystem.getOut().println (getID() + " - run");

    outputText = "";
    placeSuCuiMigrare = null;

    // Prova a caricare l'eventuale ridefinizione fatta dall'utente
    Config.caricaPropUtenteSeCiSono ();

    // DEFINIZIONE DELLA LINGUA DA USARE
    Config.defPropVariabile ("Lingua", String.valueOf(Lingua.LINGUA_DEFAULT));
    Lingua.defLingua (Config.chePropInt("Lingua"));

    // RECUPERO IL NOME (E PERCORSO) DEL FILE DI LINGUA (SUL COMPUTER DEL PLACE DI CREAZIONE).
    String dirIniAgente;
    try {
      Environment env = agentSystem.getEnvironment();
      dirIniAgente = env.agentManager.agentClassManager.getClassPathDirectory();
    }
    catch (Exception e) {
      dirIniAgente = "agents";
    }
    fileDiLingua = dirIniAgente + File.separator + this.getClass().getName();   // FILE DI LINGUA (SENZA ESTENSIONE)
    // PROVA A VEDERE SE IL FILE ESISTE; SE NO TERMINA L'AGENTE!
    if (! Lingua.esisteFileDiLingua(fileDiLingua)) {
      agentSystem.getOut().println ("Agent: CAN'T FIND ANY LANGUAGE FILE FOR THE AGENT CLASS "+fileDiLingua);
      return;  // ABORT NATURALE DELL'AGENTE
    }
    tabellaLingua = Lingua.caricaFileDiLinguaSuTabella (fileDiLingua);  // PASSO ATTRAVERSO LA TABELLA INTERNA
    // D'ora in poi user la TABELLA! (lo faccio per prima cosa nello "startMethod")

    Config.defPropVariabile ("Apparenza", Apparenza.APPARENZA_DEFAULT);
    // L'assegnazione e la registrazione viene fatta in "startMethod"

    // ATTENZIONE: NON MODIFICARE I NOMI "Lingua" e "Apparenza" perch sono gli stessi
    //             che vengono usati dalla GUI di SOMA (vedi "Apparenza.java", "Finestra.java" e "Inizio.java")

    placeVisitati = new Vector();
    placeStorici  = new Vector();

    if (mailbox != null)    // ATTENTO! SE  "NON TRACEABLE" NON C'E' LA MAILBOX!
      mailbox.mailListener = new Mailbox.MailListener() {
          public void run(){
            if (winOutFrame != null)
              winOutFrame.out.println (Lingua.frase("THEAG_TXT_GOT_MAIL"));
          }
      };

    startMethod();
  } //run

      /**
       *  Questo  il metodo di avvio dopo "Idle" e "go" (migrazione).
       */
  public void startMethod () {
    agentSystem.getOut().println (getID() + " - startMethod");

    chronometer.Stop();

    Lingua.caricaFileDiLinguaDaTabella (tabellaLingua);
    // SI REGISTRA SUL CAMBIO DI LINGUA, MA SOLO SE ESISTE UN FILE DI LINGUA (ALMENO SUL PLACE DI CREAZIONE)
    if (Lingua.esisteFileDiLingua(fileDiLingua))
      Lingua.addLinguaListener (this);

    Apparenza.defApparenza (Config.cheProp ("Apparenza"));
    UIManager.addPropertyChangeListener (this);

    // usato da ExplorerThread
    threadGroup = Thread.currentThread().getThreadGroup();

    // Mi registro per il cambio di look & feel
    UIManager.addPropertyChangeListener (this);

    creaFinestra ();

    exitSemaphore = new WaitAndTimeout (0, "< EXIT >", winOutFrame.out); // Lo ricreo perch non  serializzabile.

    PlaceID placeAtt = agentSystem.getPlaceID();    // PLACE CORRENTE (SU CUI MI TROVO)

    // CONTROLLO SE L'AGENTE E' RIUSCITO A MIGRARE FINO A DOVE VOLEVA!
    boolean stampaCrono;
    if (placeSuCuiMigrare == null)
      stampaCrono = false;
    else {
      stampaCrono = true;
      if (! placeAtt.equals(placeSuCuiMigrare)) {  // NON CE L'HO FATTA!
        OiDialogoi.mostraMessaggio (Lingua.frase("THEAG_TXT_NO_MIGR")+" '"+
                                    placeSuCuiMigrare.toString()+"'", winOutFrame);
      }
    }

    if (stampaCrono) {
      String frase = Lingua.frase("THEAG_TXT_CHRONO") +
                     (float)((chronometer.StopTime - chronometer.StartTime) / 1000) +
                     Lingua.frase("THEAG_TXT_TIME_SEC");
      winOutFrame.out.println (frase);
      OiDialogoi.mostraMessaggio (frase, winOutFrame);
    }

    // AGGIORNO GLI ELENCHI DEI PLACE VISITATI E LO STORICO
    // Avevo gi visitato questo placeID? ( nella lista dei visitati?)
    int posPreced = placeVisitati.indexOf (placeAtt);
    if (posPreced < 0)  // -1 Non c': l'aggiungo, se no la sostituisco.
      placeVisitati.addElement (placeAtt);
    else
      placeVisitati.setElementAt (placeAtt, posPreced);

    placeStorici.addElement (placeAtt);       // Nella placeStorici c' tutta la sequenza.


    if (mailbox != null)
      if (mailbox.isMessage())    // C' posta? (anzi, ci sar?)
        OiDialogoi.mostraMessaggio (Lingua.frase("THEAG_TXT_GOT_MAIL"), winOutFrame);

    //Mi fermo qui. Riparto con Exit, Go ed Idle. <============= STOP QUI!
    exitSemaphore.Wait();

    if (explorerThread != null)
      explorerThread.Stop();   //NB: con la maiuscola

    // Memorizzo il testo della finestra, in questo modo evito di serializzare tutta la finestra!
    outputText = winOutFrame.getText();

    try {
      Config.modifPropComponent (winOutFrame.getTitle(), winOutFrame);  // MODIFICO PROPR.FINESTRA
    }
    catch (Exception E) { }
    try {
      Config.salvaPropUtente();
    }
    catch (Exception E) { OiDialogoi.mostraErrore (E, winOutFrame); }

    // Si rimuove dai listener di lingua e di look & feel
    Lingua.removeLinguaListener (this);
    UIManager.removePropertyChangeListener (this);

    winOutFrame.dispose();
    agentSystem.getOut().println (getID() + " - " + Lingua.frase("THEAG_TXT_EXITING"));
  } //startMethod

      /**
       *  Interrompe l'agente - si ripartir col metodo "startMethod".
       */
  public void stop () {
    agentSystem.getOut().println (getID() + " - stop");

    winOutFrame.out.println (Lingua.frase("THEAG_TXT_STOPPING"));

    // Il metodo di avvio!
    start = "startMethod";
    outputText = winOutFrame.getText();
    chronometer.Start();
    exitSemaphore.Done();
  } //stop

      /**
       *  Legge la stringa dalla linea di input.
       */
  protected  String readLine () {
    String answer;
    try {
      answer = winOutFrame.inBufferedReader.readLine();
      winOutFrame.out.println (answer);
    }
    catch (Exception e) {
      e.printStackTrace (winOutFrame.out);
      answer = "";
    }
    return answer;
  } //readLine

      /**
       *  Crea la finestra OutputFrame2 associata all'agente.
       */
	protected void creaFinestra () {
    winOutFrame = new OutputFrame2 (Lingua.frase("THEAG_TXT_AGENT")+"["+getID()+"]",
                                    TheAgent.class.getName());

    winOutFrame.onExitCommand = new OutputFrame2.Listener() {  //Stabilisco il comportamento all'uscita
        public void run () {
          winOutFrame.out.println (Lingua.frase("THEAG_TXT_EXITING2"));
          exitSemaphore.Done();
        }
    };

    // "Esporto" nei bottoni alcune delle funzioni del men:
    ListenerMenu listBott = new ListenerMenu (this);

    botAgID = new JButton ();
    botAgID.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"Agente.gif"));
    botAgID.setCursor (Finestra.cursoreBottone);
    botAgID.setHorizontalAlignment(JLabel.LEFT);
    botAgID.setActionCommand (COMANDO_AGENTID);
    botAgID.addActionListener (listBott);

    botPlID = new JButton ();
    botPlID.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"PlaceID.gif"));
    botPlID.setCursor (Finestra.cursoreBottone);
    botPlID.setHorizontalAlignment(JLabel.LEFT);
    botPlID.setActionCommand (COMANDO_PLACEID);
    botPlID.addActionListener (listBott);

    botGoto = new JButton ();
    botGoto.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentMigra.gif"));
    botGoto.setCursor (Finestra.cursoreBottone);
    botGoto.setHorizontalAlignment(JLabel.LEFT);
    botGoto.setActionCommand (COMANDO_GOPLACE);
    botGoto.addActionListener (listBott);

    botSend = new JButton ();
    botSend.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentMailSend.gif"));
    botSend.setCursor (Finestra.cursoreBottone);
    botSend.setHorizontalAlignment(JLabel.LEFT);
    botSend.setActionCommand (COMANDO_SEND);
    botSend.addActionListener (listBott);

    botGoVi = new JButton ();
    botGoVi.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentGoVisit.gif"));
    botGoVi.setCursor (Finestra.cursoreBottone);
    botGoVi.setHorizontalAlignment(JLabel.LEFT);
    botGoVi.setActionCommand (COMANDO_GOTO_VIS);
    botGoVi.addActionListener (listBott);

    botGoHo = new JButton ();
    botGoHo.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentGoHome.gif"));
    botGoHo.setCursor (Finestra.cursoreBottone);
    botGoHo.setHorizontalAlignment(JLabel.LEFT);
    botGoHo.setActionCommand (COMANDO_GOTO_HOME);
    botGoHo.addActionListener (listBott);

    // Aggiungo i componenti al pannello "utente" della finestra OutputFrame2
    JPanel pan = winOutFrame.prePanBottoni;
    pan.setLayout(new GridLayout(2,3));
    pan.add (botGoto);
    pan.add (botGoVi);
    pan.add (botGoHo);

    pan.add (botAgID);
    pan.add (botPlID);
    pan.add (botSend);

    impostaFrasi ();

    // Ripristino la POSIZIONE e DIMENSIONE precedente (relativa allo stesso place).
    winOutFrame.setLocation (0, 0);      // Definisco la locazione
    winOutFrame.pack();                  // Compatto i componenti della finestra

    Config.defPropComponent (winOutFrame.getTitle(), winOutFrame);
    try {    // Provo a ripristinare la POSIZIONE e la DIMENSIONE precedente
      Rectangle rettangolo = Config.chePropComponent (winOutFrame.getTitle(), winOutFrame);
      winOutFrame.setLocation (rettangolo.x, rettangolo.y);
      if (winOutFrame.isResizable()) {
        winOutFrame.setSize (rettangolo.width, rettangolo.height);
      } //if
    }
    catch (Exception E) { }

    // Ripristino l'eventuale contenuto dell'area di testo (dopo una migrazione).
    winOutFrame.setText (outputText);

    winOutFrame.setVisible (true);     // Infine rendo visibile la finestra
  } //creaFinestra

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       */
  protected void impostaFrasi () {

    creaBarraMenu ();              // Ricrea la barra del men

    if (winOutFrame.testata != null)
      winOutFrame.testata.setText (TheAgent.class.getName());  // Non mi servirebbe.
    winOutFrame.labTextField.setText (Lingua.frase("THEAG_INPUT_LINE"));
    winOutFrame.botClrScr.setText (Lingua.frase("THEAG_BOT_CLEAR"));

    botAgID.setText (Lingua.frase("THEAG_BOT_AGID"));
    botPlID.setText (Lingua.frase("THEAG_BOT_PLID"));
    botGoto.setText (Lingua.frase("THEAG_BOT_GOTO"));
    botSend.setText (Lingua.frase("THEAG_BOT_SEND"));
    botGoVi.setText (Lingua.frase("THEAG_BOT_GOVI"));
    botGoHo.setText (Lingua.frase("THEAG_BOT_GOHO"));

    winOutFrame.invalidate();      // RIVALIDAZIONE DELLA FINESTRA
    winOutFrame.pack();            // Posso farlo perch  invocata da un "evento".
  } //impostaFrasi

      /**
       *  METODO RICHIESTO DALL'INTERFACCIA "LinguaListener".
       *  Viene invocato automaticamente quando qualcuno invoca la "Lingua.defLingua()"
       *  Per per l'agente c' la restrizione che NON ci si registra per ascoltare il cambio di
       *  lingua se ci si trova su un Place diverso da quello di origine!
       */
  public void linguaCambiata () {
    tabellaLingua = Lingua.caricaFileDiLinguaSuTabella (fileDiLingua);
    Lingua.caricaFileDiLinguaDaTabella (tabellaLingua);

    impostaFrasi();

    // Aggiorna la propriet di configurazione
    Config.modifPropInt ("Lingua", Lingua.cheLinguaAttuale());
  } //linguaCambiata

      /**
       *  METODO RICHIESTO DALL'INTERFACCIA "PropertyChangeListener".
       *  Viene invocato automaticamente quando qualcuno imposta un nuovo
       *  "Look & Feel" tramite un'invocazione a "UIManager.setLookAndFeel()"
       */
  public void propertyChange (PropertyChangeEvent e) {
    String lookName = UIManager.getLookAndFeel().getClass().getName();
    Config.modifProp ("Apparenza", lookName);
    SwingUtilities.updateComponentTreeUI (winOutFrame);  // Ridefinizione UI
    winOutFrame.invalidate();                            // Rivalidazione della finestra
    winOutFrame.pack();
  } //propertyChange

      /**
       *  Costruisce la barra di men - a seconda della lingua in uso.
       */
  protected void creaBarraMenu () {
    JMenuItem menuItem;
    JMenu     menuVoce, menuSub;
    JMenuBar  menuBarra = new JMenuBar();
    String    mnemoBarra, mnemoSub;
    String    spazi = "       ";   // per sicurezza

    // Creo il listener del menu.
    ListenerMenu listenerMenu = new ListenerMenu (this);

    mnemoBarra = Lingua.frase("THEAG_MENU_BAR_MNEMO") + spazi;  // mnemonici

    menuVoce = new JMenu (Lingua.frase("THEAG_MENU_AGENT"));    // men "agent"
    menuVoce.setMnemonic (mnemoBarra.charAt(0));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("THEAG_MENU_A_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_A_AGENTID"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgenteMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_AGENTID);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_A_GOPLACE"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentMigraMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_GOPLACE);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_A_IDLE"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentIdle.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(2));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_IDLE);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_A_EXIT"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"CloseIco.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(3));
        menuItem.addActionListener (winOutFrame.new WinList());
        menuVoce.add (menuItem);

    menuVoce = new JMenu (Lingua.frase("THEAG_MENU_MAIL"));
    menuVoce.setMnemonic (mnemoBarra.charAt(1));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("THEAG_MENU_M_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_M_CHECK"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentChkMail.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_CHECK);
        menuItem.setEnabled(mailbox != null);  // Se  non rintracciabile, non ha mailbox!
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_M_SEND"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentMail.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_SEND);
        menuItem.setEnabled(mailbox != null);  // Se  non rintracciabile, non ha mailbox!
        menuVoce.add (menuItem);

    menuVoce = new JMenu (Lingua.frase("THEAG_MENU_PLACE"));
    menuVoce.setMnemonic (mnemoBarra.charAt(2));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("THEAG_MENU_P_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_P_PLACEID"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"PlaceIDMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_PLACEID);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_P_DOMAINS"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"DomainNSMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(2));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_DOMAINS);
        try {
          PlaceID placeAttuale = agentSystem.getPlaceID();   // pu generare eccezione?
          menuItem.setEnabled (placeAttuale.isDomain() ||
                               (placeAttuale instanceof MobilePlaceID) );
        }
        catch (Exception e) {
          menuItem.setEnabled (false);
        }
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_P_PLACES"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"PlaceNSMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_PLACES);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_P_GETENV"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"PlaceIDMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(3));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_GETENV);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_P_ADMIN"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"RegiaMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(4));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_ADMIN);
        menuVoce.add (menuItem);

    menuVoce = new JMenu (Lingua.frase("THEAG_MENU_HISTORY"));
    menuVoce.setMnemonic (mnemoBarra.charAt(3));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("THEAG_MENU_H_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_H_HISTORY"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentHistory.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_HISTORY);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_H_VISITED"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentVisit.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_VISITED);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_H_GOTO_VIS"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentGoVisitMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(2));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_GOTO_VIS);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_H_GOTO_HOME"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"AgentGoHomeMini.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(3));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_GOTO_HOME);
        menuVoce.add (menuItem);

    menuVoce = new JMenu (Lingua.frase("THEAG_MENU_INFO"));
    menuVoce.setMnemonic (mnemoBarra.charAt(4));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("THEAG_MENU_I_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_I_IND_IP"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"IndirIP.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_LOCHOST);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("THEAG_MENU_I_MEMORY"));
        menuItem.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"Memory.gif"));
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (listenerMenu);
        menuItem.setActionCommand (COMANDO_MEMORY);
        menuVoce.add (menuItem);

    menuBarra.add (Box.createHorizontalGlue());           // aggiunge della colla

    menuVoce = new JMenu (Lingua.frase("THEAG_MENU_CONFIG"));   // men "Configurazione"
    menuVoce.setMnemonic (mnemoBarra.charAt(5));
    menuBarra.add (menuVoce);

        menuSub = LinguaGui.menuSceltaLingua(winOutFrame);      // sotto-menu' "lingua"
        menuSub.setEnabled (Lingua.esisteFileDiLingua(fileDiLingua));
        menuVoce.add (menuSub);

        menuSub = Apparenza.menuSceltaApparenza(winOutFrame);   // sotto-menu' "apparenza"
        menuVoce.add (menuSub);

    winOutFrame.setJMenuBar (menuBarra);
  } //creaBarraMenu

      /**
       *  Metodo invocato dalla FinGoto1000 dopo che l'utente preme il bottone "migra".
       *  Tale finestra  aperta dal "ListenerMenu".
       *  Viene anche invocato dalla FinAgentElencoPlace (sempre per far migrare l'agente).
       */
  public void eseguiAzioneGoto (PlaceID placeToGoTo) throws Exception {
    // NB: l'eccezione viene "presa" dalla finestra FinGoto1000, che provveder a stamparla in una finestra

    String frase = Lingua.frase("THEAG_TXT_GOINGTO") + placeToGoTo.toString();
    agentSystem.getOut().println (getID() + " - "+frase);
    winOutFrame.out.println (frase);

    PlaceID placeAtt = agentSystem.getPlaceID();

    if (! placeToGoTo.equals(placeAtt)) {
      outputText = winOutFrame.getText();

      //era: go (new PlaceID(Answer), "startMethod");
      try {

        PlaceID mobilePlaceID = MobilePlaceID.parsePlaceID (placeToGoTo.toString());

        placeSuCuiMigrare = mobilePlaceID;   // Mi ricorder il place su cui volevo migrare.

        chronometer.Start();
        go (mobilePlaceID, "startMethod");

        exitSemaphore.Done();   // Sblocco il thread in attesa.
      }
      catch (Exception e) {
        throw new Exception (Lingua.frase("THEAG_ERR_CANT_GO"));
      }
    }
    else
      throw new Exception (Lingua.frase("THEAG_ERR_SAME_PLACE"));

  } //eseguiAzioneGoto

      /**
       *  Metodi per disabilitare la finestra di chi invoca la FinGoto1000 - in caso che possano essere
       *  alterati in essa dei dati che saranno usati nel metodo "eseguiAzioneGoto".
       */
  public void disabilitaFinestra () {
    winOutFrame.setEnabled (false);
  }
  public void abilitaFinestra() {
    winOutFrame.setEnabled (true);
  }
  public void inPrimoPiano() {
    winOutFrame.toFront();
  }

      /**
       *  Metodo invocato dalla FinAgentMessage dopo che l'utente preme il bottone "send".
       *  Tale finestra  aperta dal "ListenerMenu".
       */
  public void eseguiAzioneSend (Message message) throws Exception {
    agentSystem.sendMessage (message);
  } //eseguiAzioneSend


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DELLE VOCI DEL MENU' DELLA FINESTRA.
       *  Quest'oggetto  assiciato a tutte le voci del men.
       *  Quando serve l'esecuzione dell'azione  fatta in un thread separato,
       *  in modo da non bloccare la GUI. Non  fatto sempre perch NON si possono
       *  invocare metodi delle SWING al di fuori di "eventi".
       *  Non  un oggetto serializzabile.
       */
	class ListenerMenu implements ActionListener {
    protected TheAgent theAgent;

    public ListenerMenu (TheAgent theAgent) {
      this.theAgent = theAgent;
    } //ListenerMenu

    public void actionPerformed (ActionEvent evento) {

      // PRELEVO L'AZIONE DA ESEGUIRE
      final String comando = evento.getActionCommand();

      if (comando.equals(COMANDO_AGENTID)) {
        FinAgentInfo fin = new FinAgentInfo (getID());
      }

      else if (comando.equals(COMANDO_GOPLACE)) {
        Environment env = agentSystem.getEnvironment();
        FinGoto1000 fin = new FinGoto1000 (theAgent, env.actionPlace);
        // Apre la finestra di richiesta la quale invocher "theAgent.eseguiAzioneGoto()"
      }

      else if (comando.equals(COMANDO_IDLE)) {
            Thread oziatore = new Thread ("Going Idle Thread") {
                    public void run() {
                      OiDialogoi.mostraMessaggio (Lingua.frase("THEAG_TXT_GOING_IDLE"), winOutFrame);

                      winOutFrame.out.println (Lingua.frase("THEAG_TXT_BYEBYELOVE"));
                      idle ("startMethod");

                      chronometer.Start();
                      exitSemaphore.Done(); //Sblocco il thread in attesa.
                    } //run
            }; //oziatore (Thread)
            oziatore.start();
      }

      else if (comando.equals(COMANDO_CHECK)) {
        if (!mailbox.isMessage())
          OiDialogoi.mostraMessaggio (Lingua.frase("THEAG_TXT_NO_MAIL"), winOutFrame);
        else
          while (mailbox.isMessage()) {
            Message message = mailbox.getMessage();
            FinAgentMessage fin = new FinAgentMessage (message, theAgent);
          }
      }

      else if (comando.equals(COMANDO_SEND)) {
        FinAgentMessage fin = new FinAgentMessage (theAgent.getID(), theAgent);
        // Quando si premer "SEND" si avviser l'agente invocando il metodo "eseguiAzioneSend()".
      }

      else if (comando.equals(COMANDO_PLACEID)) {
        PlaceID placeID = agentSystem.getPlaceID();
        FinPlaceInfo fin = new FinPlaceInfo (placeID);
      }

      else if (comando.equals(COMANDO_PLACES)) {
        Environment env = agentSystem.getEnvironment();
        // Apre la finestra PNS ma SENZA BOTTONI DI MODIFICA!
        ModelloPNS fin = new ModelloPNS (env, FinestraXNS.MOSTRA_SOLO);
      }

      else if (comando.equals(COMANDO_DOMAINS)) {
        Environment env = agentSystem.getEnvironment();
        if (env.placeID.isDomain() ||
           (env instanceof MobileEnvironment)) {
             // Apre la finestra DNS ma SENZA BOTTONI DI MODIFICA!
             ModelloDNS fin = new ModelloDNS (env, FinestraXNS.MOSTRA_SOLO);
        }
      }

      else if (comando.equals(COMANDO_GETENV)) {
        try {
          Environment env = agentSystem.getEnvironment();

          winOutFrame.out.println (Lingua.frase("THEAG_TXT_GET_ENV"));
          winOutFrame.out.println (env.toString());
        }
        catch (SecurityException e) {
          winOutFrame.out.println (Lingua.frase("THEAG_TXT_GABBOLATO"));
          winOutFrame.out.println (e.toString());
        }
      }

      else if (comando.equals(COMANDO_ADMIN)) {
        if (explorerThread != null)
          if (explorerThread.isAlive()) {
            Thread killer = new Thread ("Killer for Explorer Thread, in Agent") {
                    public void run() {
                      explorerThread.Stop();  //NB: con la maiuscola (non lo "stop" invalidato dal JDK1.2)
                      // NOTA BENE: IN OGNI CASO QUESTO BENEDETTO "ExplorerThread" NON VUOLE MUORIRE!
                      // ALL'INVOCAZIONE DELLA "Stop()" CI SI BLOCCA (PRIMITIVA SOSPENSIVA) IN ATTESA
                      // DI UNA MORTE CHE MAI AVVERRA'.
                      explorerThread = null;
                      winOutFrame.out.println (Lingua.frase("THEAG_TXT_ADMIN_STOP"));
                    } //run
            }; //killer (Thread)
            killer.start();
          }
          else ; // nulla
        else {  //explorerThread = null
          try {
            Environment env = agentSystem.getEnvironment();
            explorerThread = new ExplorerThread (threadGroup, env.dir, winOutFrame.in, winOutFrame.out, true);
            explorerThread.start();

            winOutFrame.out.println (Lingua.frase("THEAG_TXT_EXPLORING"));
            winOutFrame.out.println (Lingua.frase("THEAG_TXT_EXPLORING2"));
          }
          catch (Exception e) { OiDialogoi.mostraErrore (e, winOutFrame); }
        }
      }

      else if (comando.equals(COMANDO_HISTORY)) {
        Environment env = agentSystem.getEnvironment();
        FinAgentElencoPlace fin = new FinAgentElencoPlace (placeStorici,
                                                           Lingua.frase("THEAG_TXT_HISTORY"),
                                                           getID().getHome(), env.placeID);
      }

      else if (comando.equals(COMANDO_VISITED)) {
        Environment env = agentSystem.getEnvironment();
        FinAgentElencoPlace fin = new FinAgentElencoPlace (placeVisitati,
                                                           Lingua.frase("THEAG_TXT_VISITED"),
                                                           getID().getHome(), env.placeID);
      }

      else if (comando.equals(COMANDO_GOTO_VIS)) {
        Environment env = agentSystem.getEnvironment();
        FinAgentElencoPlace fin = new FinAgentElencoPlace (placeVisitati,
                                                           theAgent,       // Con bottone "GO-TO"
                                                           Lingua.frase("THEAG_TXT_VISITED"),
                                                           getID().getHome(), env.placeID);
        // Apre la finestra la quale se si preme "GoTo" invocher la "theAgent.eseguiAzioneGoto()"
      }

      else if (comando.equals(COMANDO_GOTO_HOME)) {
        PlaceID placeCasa = getID().getHome();
        try {
          theAgent.eseguiAzioneGoto (placeCasa);
        }
        catch (Exception ecciu) {
          OiDialogoi.mostraErrore (ecciu, winOutFrame);
        }
      }

      else if (comando.equals(COMANDO_LOCHOST)) {
        InetAddress indLocale;
        try {
          indLocale = InetAddress.getLocalHost();
        }
        catch (java.net.UnknownHostException E) {
          indLocale = null;
        }
        boolean errUnk = (indLocale == null);
        FinLocalHost fin = new FinLocalHost(indLocale, errUnk);
      }

      else if (comando.equals(COMANDO_MEMORY)) {
        long memTotale = Runtime.getRuntime().totalMemory();
        long memLibera = Runtime.getRuntime().freeMemory();
        long memUsata  = memTotale - memLibera;
        FinMemory fin = new FinMemory (memTotale, memLibera, memUsata);
      }

    } //actionPerformed
  } //ListenerMenu (class)

} //TheAgent