/**  PosizioneAgenti
 *     Finestra per mostrare e "manipolare" gli agenti presenti in un certo place (locale).
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.Environment;
import SOMA.naming.PlaceID;
import SOMA.naming.AgentID;
import SOMA.agent.mobility.AgentPositionStore;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;


public class PosizioneAgenti extends Finestra {

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_UPDATE  = new ImageIcon(PICTURE_PATH+"AgentUpdate.gif");
  protected static final ImageIcon IMG_ICO_CANC    = new ImageIcon(PICTURE_PATH+"BotKO.gif");
  protected static final ImageIcon IMG_ICO_ZAMPA   = new ImageIcon(PICTURE_PATH+"Zampina.gif");

      /**
       *  Per memorizzare i parametri passati al costruttore, 
       *  in modo che siano visibili anche agli altri metodi.
       */
  protected Environment env;
  protected AgentPositionStore mioAgentPositionStore;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected PanChePlace panChePlace;
  protected JLabel      labAgente;
  protected JTable      tabella;
  protected TableModel  modelloTabella;
  protected JScrollPane tabellaScroll;
  protected JButton     botUpdate, botClose;
      /**
       *  Costruzione della finestra per la visualizzazione e modifica del D/P-NS.
       *  Il {@link SOMA.gui.ModelloXNS} passato specifica il modello che usa questa finestra.
       *  Sar a lui che verranno richiesti i dati da stampare e a cui saranno 
       *  inoltrati i comandi.
       */
  public PosizioneAgenti (Environment env) {
    super (70, 40);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.env = env;
    this.mioAgentPositionStore = env.agentManager.agentPositionStore;

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    PlaceID placeID = env.placeID;
    panChePlace = new PanChePlace (placeID);

    labAgente = new JLabel ();

    botUpdate = new JButton ();
    botClose  = new JButton ();

    botUpdate.setCursor (cursoreBottone);
    botClose .setCursor (cursoreBottone);

    modelloTabella = new TabellaAgenti();
    tabella = new JTable (modelloTabella);
    tabella.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);

    tabellaScroll = new JScrollPane (tabella);
    tabella.setPreferredScrollableViewportSize (new Dimension(400, 84));
    tabellaScroll.setMinimumSize (new Dimension(50,30));
    tabellaScroll.updateUI();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose bottoniera = new ListClose(this);
    botClose  .addActionListener (bottoniera);

    botUpdate.setIcon (IMG_ICO_UPDATE);
    botClose .setIcon (IMG_ICO_CANC);
    botClose .setPressedIcon(IMG_ICO_ZAMPA);

    // USO Window Listener
    mioFrame.addWindowListener (bottoniera);

    botUpdate.addActionListener (new ActionListener() {
                                       public void actionPerformed(ActionEvent e) {
                                         tabella.clearSelection();
                                         tabella.revalidate();
                                       }
                                 });

    PanCentro.setLayout (new BorderLayout());

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 5, 6, 5));   // alto,sx,basso,dx

    Component spazio;

    JPanel panPlace = new JPanel();
    GridBagLayout GBL2     = new GridBagLayout();
    GridBagConstraints CC2 = new GridBagConstraints();
    panPlace.setLayout (GBL2);
      CC2.gridx = 1;   CC2.gridy = 1;
      CC2.anchor = GridBagConstraints.CENTER;
      GBL2.setConstraints (panChePlace, CC2);
      panPlace.add (panChePlace);
      spazio = Box.createRigidArea (new Dimension(4,6));
      CC2.gridx = 1;   CC2.gridy = 2;
      CC2.anchor = GridBagConstraints.CENTER;
      GBL2.setConstraints (spazio, CC2);
      panPlace.add (spazio);
      CC2.gridx = 1;   CC2.gridy = 3;
      CC2.anchor = GridBagConstraints.WEST;
      GBL2.setConstraints (labAgente, CC2);
      panPlace.add (labAgente);
    panPlace.setBorder (BorderFactory.createEmptyBorder(0, 0, 4, 0));   // alto,sx,basso,dx
    PanCentro.add (panPlace, BorderLayout.NORTH);

    PanCentro.add (tabellaScroll, BorderLayout.CENTER);

    JPanel panBott = new JPanel();
    GridBagLayout GBL3     = new GridBagLayout();
    GridBagConstraints CC3 = new GridBagConstraints();
    panBott.setLayout (GBL3);

      CC3.fill = GridBagConstraints.VERTICAL;

      CC3.anchor = GridBagConstraints.WEST;
      CC3.gridx = 1;   CC3.gridy = 1;
      GBL3.setConstraints (botUpdate, CC3);
      panBott.add (botUpdate);

      spazio = Box.createRigidArea (new Dimension(20,4));
      CC3.gridx = 2;   CC3.gridy = 1;
      GBL3.setConstraints (spazio, CC3);
      panBott.add (spazio);

      CC3.anchor = GridBagConstraints.EAST;
      CC3.gridx = 3;   CC3.gridy = 1;
      GBL3.setConstraints (botClose, CC3);
      panBott.add (botClose);
      panBott.setBorder (BorderFactory.createEmptyBorder(15, 10, 0, 10));   // alto,sx,basso,dx
    PanCentro.add (panBott, BorderLayout.SOUTH);

    mioFrame.setResizable (true);     // La finestra place e' ridimensionabile

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    panChePlace.distruggimi();

    super.distruggiFinestra();
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("PA_WIN_TITLE"));

    labAgente.setText (Lingua.frase("PA_ECCO_AGENTI"));

    botUpdate.setText (Lingua.frase("PA_BOT_UPDATE"));
    botClose .setText (Lingua.frase("PA_BOT_CLOSE"));

    tabella  .setToolTipText (Lingua.frase("PA_TIP_TABLE"));
    botUpdate.setToolTipText (Lingua.frase("PA_TIP_UPDATE"));
    botClose .setToolTipText (Lingua.frase("PA_TIP_CLOSE"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      
      /**
       *  CLASSE INTERNA CHE DEFINISCE IL "MODELLO" A CUI SI RIFERISCE LA TABELLA DEGLI AgentID.
       *  Vedi classe {@link javax.swing.table.AbstractTableModel}
       *  Nota Bene: c' un side-effect sulla variabile "mioAgentPositionStore" della classe contenitrice!
       */
  public class TabellaAgenti extends AbstractTableModel {

      /**
       *  Rende il numero di colonne della tabella.
       */
    public int getColumnCount () { 
      return 2;
    } //getColumnCount

      /**
       *  Rende il numero di righe della tabella.
       */
    public int getRowCount () { 
      // Chiedo all'AgentPositionStore l'elenco di tutti i dominii
      AgentID[] arrPlaceID = mioAgentPositionStore.cheElencoAgenti();
      // Se la precedente linea d "errore" significa che manca il 
      // metodo "cheElencoAgenti()" aggiunto da Luigi all'AgentPositionStore
      return arrPlaceID.length;
    } //getRowCount

      /**
       *  Rende il valore (sottoforma di oggetto) contenuto nella tabella in posizione (row,col).
       */
    public Object getValueAt (int row, int col) {
      // Chiedo all'AgentPositionStore l'elenco di tutti i dominii
      AgentID[] arrAgentID = mioAgentPositionStore.cheElencoAgenti();
      // Se la precedente linea d "errore" significa che manca il 
      // metodo "cheElencoAgenti()" aggiunto da Luigi all'AgentPositionStore

      // E rendo l'oggetto relativo alla colonna (basato sull'AgentWorker trovato)
      if ((row >= 0) && (row < arrAgentID.length)) {
        switch (col) {
          case  0: return arrAgentID[row];
          case  1: return (PlaceID) mioAgentPositionStore.get(arrAgentID[row]);
          default: return null;
        }
      }
      else
        return null;
    } //getValueAt

      /**
       *  Rende il nome della colonna "col", cio l'informazione "intensiva".
       */
    public String getColumnName (int col) {
      switch (col) {
        case  0: return Lingua.frase("PA_AG_AGEID");
        case  1: return Lingua.frase("PA_AG_PLACE");
        default: return null;
      }
    } //getColumnName

      /**
       *  Rende la classe degli oggetti relativi alla colonna "col".
       *  Necessaria per un buon "allineamento" delle stringhe a sinistra e dei numeri a destra!
       */
    public Class getColumnClass(int col) {
      return getValueAt(0,col).getClass();
    } //getColumnClass

      /**
       *  La cella in posione (row,col) pu essere modificata dall'utente?
       */
    public boolean isCellEditable (int row, int col) {
      return false;
    } //isCellEditable

  } //TabellaAgenti (classe)

} //PosizioneAgenti