/**  PanTestoSC
 *     Pannello contenete una linea di testo e i cui caratteri sono prelevati 
 *     da dei file (contenenti ciascuno l'immagine corrispondente a un certo
 *     carattere).
 *     Pu sembrare molto inutile, ma penso che sia di grande effetto (soprattutto
 *     se si considera che il tutto sta in un centinaio di linee di codice).
 *     Osservazione: le immagini delle lettere vengono caricate tutte in una
 *     volta e una volta per tutte alla creazione del primo pannello.
 *     @author     Luigi Antenucci
 *     @version    3.5
 *     @language   jdk 1.2
 */

package SOMA.gui;

import java.io.Serializable;
import java.io.File;
import java.io.FilenameFilter;
import java.awt.*;
import javax.swing.*;


public class PanTestoSC extends JPanel implements Serializable {

  // Costanti pubbliche
      /**
       *  Da questo direttorio andr a prelevare i file con le immagini delle lettere.
       */
  public static final String CHAR_PATH = Finestra.PICTURE_PATH+"lettere"+File.separator;

  // Variabili di classe:
      /**
       *  Qui ci memorizzo le immagini di tutti i possibili caratteri.
       *  E` "statico", cio  visibile a tutte le istanze di questa classe.
       */
  protected static  ImageIcon[] arrLettere = null;

      /**
       *  Questo  il carattere usato per i caratteri che non hanno una corrispondente immagine.
       */
  protected static final String    nomeFileNull = "_$.gif";
  protected static final ImageIcon letteraNulla = new ImageIcon (CHAR_PATH+nomeFileNull);

      /**
       *  Questa tabella mi serve per mappare la trasformazione di un carattere
       *  in una posizione nell'array di immagini.
       */
  protected static  int[] arrPos = null;

      /**
       *  Potermi ricordare la massima dimensione in Y dei caratteri mi permette 
       *  di allineare il lato basso di ogni lettera su una linea fittizia.
       */
  protected static  int maxDimY = 0;

  // Variabili private:
      /**
       *  Qui ci memorizzo la frase da stampare nel pannello.
       */
  protected String cheFrase;


      /**
       *  Creo un pannello di testo, ma senza alcun testo.
       */
  public PanTestoSC () {
    this (" ");
  } //costruttore

      /**
       *  Creo un pannello di testo riempito sol testo passato.
       */
  public PanTestoSC (String Testo) {
    super ();
    if (arrLettere == null)       // PRECARICA TUTTI I CARATTERI
      CaricaSetDiCaratteri ();

    setOpaque (false);  // Questo pannello NON sar "opaco" ma TRASPARENTE: ci vedo attraverso
    setText (Testo);
  } //costruttore

      /**
       *  Rimpiazzo il testo esistente con il nuovo testo passato
       */
  public void setText (String Testo) {
    cheFrase = Testo;
    aggiornaPrefSize();
  } //setText

      /**
       *  Accodo al testo gi esistente il testo passato
       */
  public void appendText (String Testo) {
    cheFrase = cheFrase + Testo;
    aggiornaPrefSize();
  } //appendText

      /**
       *  Calcola e aggiorna la dimensione del pannello in base alla dimensione
       *  delle immagini delle lettere in esso contenute.
       */
  protected void aggiornaPrefSize () {
    Dimension dim;
    if (Config.chePropBool("UsaTestoSC")) {
      int maxX = 0;
      int pos;
      ImageIcon img;
      for (int i=0; i<cheFrase.length(); i++) {
        pos = arrPos[ cheFrase.charAt(i) ];
        if (pos >= 0 )
          img = arrLettere[pos];
        else
          img = letteraNulla;
        maxX = maxX + img.getIconWidth();
      }
      dim = new Dimension (maxX, maxDimY);
    }
    else
      dim = new Dimension (4, 4);
    setMinimumSize (dim);
    setPreferredSize (dim);                 // Nuova dimensione del pannello
    revalidate();
  } //aggiornaPrefSize

      /**
       *  SOVRASCRIVO LA "paintComponent" del "JPanel".
       *  In questo modo faccio un ritracciamento come voglio io usando 
       *  la zona grafica "Graphics" passatami quando  il momento di disegnare.
       */
  protected void paintComponent (Graphics g) {
    if (Config.chePropBool("UsaTestoSC")) {
      int pos;
      int h;
      ImageIcon img;
      int x = 0;
      for (int i=0; i<cheFrase.length(); i++) {
        pos = arrPos[ cheFrase.charAt(i) ];
        if (pos >= 0 )
          img = arrLettere[pos];
        else
          img = letteraNulla;
        h = img.getIconHeight();
        img.paintIcon (this, g, x, maxDimY-h);
        x = x + img.getIconWidth();
      } //for
    }
  } //paintComponent


  protected void CaricaSetDiCaratteri () {
    File dirLettere = new File (CHAR_PATH);
    File[] elencoLettere = dirLettere.listFiles (
         new FilenameFilter () {
           public boolean accept (File dir, String name) {
             // file accettabile se termina con l'estensione "gif".
             int L = name.length();
             if (L > 4) {
               String finale = name.substring(L-4);
               return finale.equalsIgnoreCase(".gif");
             }
             else
               return false;
           } //accept
         });
    arrLettere = new ImageIcon [elencoLettere.length];
    arrPos     = new int       [128];
    for (int k=0; k<arrPos.length; k++)         // Inizializza array delle posizioni
      arrPos[k] = -1;
    int y;
    String nome;
    char primoCar, secondoCar, cheCar;
    for (int i=0; i<elencoLettere.length; i++) {
      nome = elencoLettere[i].getName();
      primoCar   = nome.charAt(0);
      secondoCar = nome.charAt(1);    // Tutt'al pi prender il "."
      if ((primoCar == 'l') || (primoCar == 'L'))     // LETTERE MAIUSCOLE
        cheCar = Character.toLowerCase(secondoCar);
      else
        if ((primoCar == 'u') || (primoCar == 'U'))   // LETTERE MINUSCOLE
          cheCar = Character.toUpperCase(secondoCar);
        else
          if (primoCar == '_') {                      // CARATTERE DI "SISTEMA" PER: 
            if (secondoCar == '_')                    // - CARATTERE DI SPAZIO
              cheCar = ' ';
            else
              if (secondoCar == '.')                  // - CARATTERE DI "_"
                cheCar = '_';
              else
                cheCar = '\0';
          }
          else
            if ((primoCar >= '!') && (primoCar <= '')) // Altri caratteri
              cheCar = primoCar;
            else {
              cheCar = '\0';                            // *SCONOSCIUTO* (non posso caricarlo)
              if (! nome.equalsIgnoreCase(nomeFileNull))
                System.out.println ("PanTestoSC - Character Unknown for File: "+nome);
            }
      if (cheCar != '\0') {
        // DEBUG: System.out.print (cheCar);
        arrLettere[i] = new ImageIcon (CHAR_PATH + nome);
        arrPos[cheCar] = i;         // Da pos[car] risalgo all'indice in arrLet
        y = arrLettere[i].getIconHeight();
        if (y > maxDimY) 
          maxDimY = y;    // Mi ricordo la massima dimensione in Y
      }
    } //for
  } //CaricaSetDiCaratteri

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    JFrame F = new JFrame ();
    F.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    F.addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent e) { 
                          System.exit(0); 
                        }
                    });
    Container contentPane = F.getContentPane();
    PanTestoSC pan = new PanTestoSC ("GigiPrima");
    pan.setText ("ABCD abcd");
    pan.appendText (" 125");
    pan.appendText (" EFG efg");
    contentPane.add (pan, BorderLayout.CENTER);
    F.pack();
    F.setVisible (true);          // INFINE RENDO VISIBILE LA FINESTRA
  }
*/

} //PanTestoSC