/**  PanNomePorta
 *     Pannello per input (con text-field) di un nome place e di una porta.
 *     Ne ho fatto una classe apposta perch questo "particolare" tipo di input
 *     viene richiesto in pi di una finestra. La modularit innanzitutto, no?.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class PanNomePorta extends Pannello {

  // Costanti pubbliche:
      /**
       *  Costanti da dare al costruttore per dire se si sta creando un pannello
       *  per l'input di un dominio (place di default) o di un place.
       */
  public static final  int  PAN_DOMINIO = 0;
  public static final  int  PAN_PLACE   = 1;

  // Variabili PROTETTE:
      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel     labNome, labPorta;
  protected JTextField txtNome, txtPorta;

      /**
       *  Oggetti passati al costruttore del pannello.
       */
  protected int PanDomPlace;


      /**
       *  Costruisco un pannello per l'input di un place di default o di un place
       *  (a seconda del valore dell'intero passato).
       */
  public PanNomePorta (int PanDomPlace) {
    super ();
    this.PanDomPlace = PanDomPlace;

    costruisciPannello ();
  } //costruttore

      /**
       *  Costruzione del pannello
       */
  public void costruisciPannello () {
    labNome  = new JLabel ();
    labPorta = new JLabel ();

    txtNome  = new JTextField (30);
    txtPorta = new JTextField (6);

    setBorder (BorderFactory.createEmptyBorder(0, 60, 10, 0));   // alto,sx,basso,dx

    GridBagLayout GBL     = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    setLayout (GBL);

    CC.gridx = 1;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labNome, CC);
    add (labNome);

    CC.gridx = 2;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtNome, CC);
    add (txtNome);

    Component spazio = Box.createRigidArea (new Dimension(4,4));
    CC.gridx = 2;   CC.gridy = 2;
    GBL.setConstraints (spazio, CC);
    add (spazio);

    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labPorta, CC);
    add (labPorta);

    CC.gridx = 2;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtPorta, CC);
    add (txtPorta);

    impostaFrasi ();

    FineCostruisciPannello();
  } //costruisciPannello

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI).
       */
  protected void impostaFrasi () {
    if (PanDomPlace == PAN_DOMINIO)
      labNome.setText (Lingua.frase("PNP_DOMAIN"));
    else
      labNome.setText (Lingua.frase("PNP_PLACE"));
    labPorta.setText (Lingua.frase("PNP_PORT"));

    if (PanDomPlace == PAN_DOMINIO)
      txtNome.setToolTipText (Lingua.frase("PNP_TIP_DOMAIN"));
    else
      txtNome.setToolTipText (Lingua.frase("PNP_TIP_PLACE"));
    txtPorta .setToolTipText (Lingua.frase("PNP_TIP_PORT"));

    FineImpostaFrasi();
  } //impostaFrasi

      /**
       *  Permette la disabilitazione degli elementi contenuti nel pannello.
       */
  public void disabilitami () {
    labNome .setEnabled(false);
    labPorta.setEnabled(false);
    txtNome .setEditable(false);
    txtPorta.setEditable(false);
  } //disabilitami

      /**
       *  Permette la riabilitazione degli elementi contenuti nel pannello (dopo una "disabilitami").
       */
  public void abilitami () {
    labNome .setEnabled(true);
    labPorta.setEnabled(true);
    txtNome .setEditable(true);
    txtPorta.setEditable(true);
  } //abilitami

      /**
       *  Rende il nome (del place o del place di default) leggendolo dal text-field.
       */
  public String cheNome () {
    return txtNome.getText();
  } //cheNome

      /**
       *  Riempie il text-field del place col nome passato.
       */
  public void defNome (String Nome) {
    txtNome.setText(Nome);
  } //defNome

      /**
       *  Rende la porta (del place o del place di default) leggendolo dal text-field.
       *  La porta  resa sottoforma di stringa.
       */
  public String chePortaStr () {
    return txtPorta.getText();
  } //chePortaStr

      /**
       *  Rende la porta (del place o del place di default) leggendolo dal text-field.
       *  La porta  resa sottoforma di intero.
       */
  public int chePortaInt () {
    return Integer.parseInt (txtPorta.getText());
  } //chePortaInt

      /**
       *  Riempie il text-field della porta col valore intero passato.
       */
  public void defPorta (int Porta) {
    txtPorta.setText(String.valueOf(Porta));
  } //defPorta

      /**
       *  Riempie il text-field della porta colla stringa passata.
       */
  public void defPorta (String Porta) {
    txtPorta.setText(Porta);
  } //defPorta

      /**
       *  Usate per la pressione di INVIO sulle aree di testo
       */
  public void addActionListener (ActionListener AL) {
    txtNome .addActionListener (AL);
    txtPorta.addActionListener (AL);
  } //addActionListener

  public void removeActionListener (ActionListener AL) {
    txtNome .removeActionListener (AL);
    txtPorta.removeActionListener (AL);
  } //removeActionListener

} //PanNomePorta