/**  PanInfoDNS
 *     Pannello per visualizzare le informazioni aggiuntive del DNS.
 *     Verr dato alla FinestraXNS che usa un ModelloDNS alla chiamata a "ModelloDNS.pannelloInfoInPiu".
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.Environment;
import SOMA.naming.PlaceID;

import java.util.Vector;
import java.awt.*;
import javax.swing.*;


public class PanInfoDNS extends Pannello {

  // Variabili PROTETTE:
      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel     labPadre, labFigli;
  protected JTextField txtPadre;
  protected JList      lstFigli;
  protected Vector     elencoFigli;

      /**
       *  Il PlaceID passato al costruttore.
       */
  protected Environment env;

      /**
       *  Per ricordarsi se si  o meno il DNS radice della gerarchia.
       */
  protected boolean sonoRadice;

      /**
       *  Per ricordarsi se si  o meno uno dei DNS foglia della gerarchia.
       */
  protected boolean sonoFoglia;


      /**
       *  Costruisco un pannello che mostra i dati della parentela del DNS.
       */
  public PanInfoDNS (Environment env) {
    super ();
    this.env = env;

    costruisciPannello ();
  } //costruttore

      /**
       *  Costruzione del pannello
       */
  public void costruisciPannello () {
    labPadre = new JLabel ();
    labFigli = new JLabel ();

    PlaceID placeGen = env.domainNameService.getParentDNS ();
    // anzich  PlaceID placeGen = Anagrafe.rendiGenitoreDNS(placeID);

    sonoRadice = (placeGen == null);           // Sono il nodo radice della gerarchia di DNS?

    if (! sonoRadice)
      txtPadre = new JTextField (placeGen.toString());
    else
      txtPadre = new JTextField (Lingua.frase("PIDNS_DNSROOT"));
    txtPadre.setEnabled (false);

    elencoFigli = env.domainNameService.getChildrenDNS ();
    // anzich  elencoFigli = Anagrafe.rendiFigliDNS(placeID);

    sonoFoglia = (elencoFigli.size() == 0);    // Sono uno dei nodi foglia della gerarchia di DNS?

    if (sonoFoglia)
      elencoFigli.addElement(Lingua.frase("PIDNS_NOFIGLI"));

    lstFigli = new JList (elencoFigli);
    lstFigli.setEnabled(false);
    lstFigli.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane scrollList = new JScrollPane(lstFigli);
    scrollList.setPreferredSize (new Dimension(250,55));
    scrollList.setMinimumSize (new Dimension(50,10));

    GridBagLayout GBL     = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    setLayout (GBL);

    CC.gridx = 1;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labPadre, CC);
    add (labPadre);

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.NORTHEAST;
    GBL.setConstraints (labFigli, CC);
    add (labFigli);

    CC.fill = GridBagConstraints.HORIZONTAL;

    CC.gridx = 2;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtPadre, CC);
    add (txtPadre);

    CC.gridx = 2;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (scrollList, CC);
    add (scrollList);

    impostaFrasi ();

    FineCostruisciPannello();
  } //costruisciPannello

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI).
       */
  protected void impostaFrasi () {
    labPadre.setText (Lingua.frase("PIDNS_GENIT"));
    labFigli.setText (Lingua.frase("PIDNS_FIGLI"));
    if (sonoRadice)
      txtPadre.setText (Lingua.frase("PIDNS_DNSROOT"));
    if (sonoFoglia) {
      try {
        elencoFigli.removeAllElements();
        // BACO DI SWING SOTTO WIN95: genera eccezione se il combo-box  vuoto!
        // NB: sotto Win NT funziona tutto correttamente (no eccezione)
      }
      catch (Exception e) { }
      elencoFigli.addElement(Lingua.frase("PIDNS_NOFIGLI"));
    }

    FineImpostaFrasi();
  } //impostaFrasi

} //PanInfoDNS