/**  PanChePlace
 *     Pannello per mostrare l'identificatore del place corrente (senza permettere un cambiamento).
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.naming.PlaceID;

import java.awt.*;
import javax.swing.*;


public class PanChePlace extends Pannello {

  // Variabili PROTETTE:
      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel     labPlace;
  protected JTextField txtPlace;

      /**
       *  Il PlaceID passato al costruttore.
       */
  protected PlaceID placeID;

      /**
       *  Costruisco un pannello per mostrare un identificatore di place,
       *  ma per ora sar tutto vuoto.
       */
  public PanChePlace () {
    this (null);
  } //costruttore

      /**
       *  Costruisco un pannello che mostra l'identificatore del place {@link SOMA.naming.PlaceID} passato.
       */
  public PanChePlace (PlaceID placeID) {
    super ();
    this.placeID = placeID;

    costruisciPannello ();
  } //costruttore

      /**
       *  Costruzione del pannello
       */
  public void costruisciPannello () {
    labPlace = new JLabel ();
    txtPlace = new JTextField (28);
    txtPlace.setEnabled (false);
    defPlace (placeID);

    GridBagLayout GBL     = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    setLayout (GBL);

    CC.gridx = 1;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labPlace, CC);
    add (labPlace);

    CC.gridx = 2;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtPlace, CC);
    add (txtPlace);

    impostaFrasi ();

    FineCostruisciPannello();
  } //costruisciPannello

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI).
       */
  protected void impostaFrasi () {
    labPlace.setText (Lingua.frase("PCP_PLACE_ID"));

    FineImpostaFrasi();
  } //impostaFrasi

      /**
       *  Imposta il pannello per visualizzare l'ID del place {@link SOMA.naming.PlaceID} passato.
       */
  public void defPlace (PlaceID newPlaceID) {
    if (newPlaceID == null)
      txtPlace.setText("");
    else
      txtPlace.setText(" "+newPlaceID.toString()+" ");
  } //defPlace

      /**
       *  Imposta il pannello per visualizzare una stringa anzich un nome di place.
       */
  public void defFrase (String frase) {
    txtPlace.setText(frase);
  } //defFrase

} //PanChePlace