/**  OutputFrame2
 *     Pannello 
 *     Frame per l'interfaccia utente: fornisce una console grafica con un input stream, 
 *     un output stream, un buffered input reader e meccanismi di sincronizzazione per la chiusura.
 *     Ho preso spunto da quanto fatto da Livio in "SOMA.output.OutputFrame", ma
 *     ho usato i miei pannelli di I/O in modo da usare le SWING.
 *     @author     Luigi Antenucci (dopo Livio Profiri)
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.ListExit;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class OutputFrame2 extends JFrame {

      /**
       *  Analogo a System.out
       */
	public transient PrintStream out;
  public TextAreaOutputStream2 txtAreaOut;

      /**
       *  Analogo a System.in
       */
	public TextFieldInputStream2 in;
	public transient BufferedReader inBufferedReader;

      /**
       *  Poco ortodosso ma comodo.
       *  ExitCommand.exe() Viene chiamato all'uscita.
       *  E` un campo public, si pu modificare a piacere.
       */
  public Listener onExitCommand;

  // Questa  l'inizializzazione di ExitCommand
  // questo pezzo di codice viene eseguito prima del costruttore.
	{
	  onExitCommand = new Listener() {
	      public void run() {}
    };
	}

      /**
       *  Tutti gli oggetti contenuti nella finestra (il cui testo dipende dalla lingua).
       *  Il testo NON viene assegnato in questa finestra. Deve farlo chi usa questa finestra!
       *  Per es. facendo "outputFrame2.botClrScr.setText("pulisci");"
       */
  public JTextArea  textArea;
  public JTextField textField;
  public JLabel     labTextField;
  public JButton    botClrScr;
  public PanFontDim panFontDim;

  public PanTestoSC testata;

      /**
       *  Pannello vuoto, inserito prima del pannello coi bottoni di default.
       *  Utile per inserirvi i propri bottoni.
       *  Questo pannello viene CREATO E INSERITO LI' DA QUESTA CLASSE.
       *  Dopo la costruzione lo si pu riempire con ci che si vuole, ma farlo sempre PRIMA di
       *  chiamare la "setVisible" sulla finestra!
       */
  public JPanel prePanBottoni;

      /**
       *  Anche questo  poco elegante, ma molto pratico:
       *  All'uscita quindi vengono fatte 3 cose per facilitare
       *  il coordinamento:
       *   - viene messo a true timeToExit
       *   - viene lanciato un notifyAll sul Monitor dell'OutputFrame2
       *   - viene chiamato onExitCommand.exe()
       */
	public boolean timeToExit = false;

      /**
       *  Propriet di "Config" per ricordarsi la dimensione del font della finestra.
       */
  protected static final String CONFIG_TXT_DIM = "Out2FontTxtDim";

      /**
       *  Costruttore della finestra.
       *  NB: la si crea ma NON la si mostra; usare "outputFrame2.setVisible(true);"
       */
	public OutputFrame2 () {
		this ("SOMA", null, null);
	} //costruttore

      /**
       *  Costruttore della finestra con titolo.
       *  NB: la si crea ma NON la si mostra; usare "outputFrame2.setVisible(true);"
       */
	public OutputFrame2 (String titolo) {
		this (titolo, null, null);
	} //costruttore

      /**
       *  Costruttore della finestra con titolo e listener.
       *  NB: la si crea ma NON la si mostra; usare "outputFrame2.setVisible(true);"
       */
	public OutputFrame2 (String titolo, Listener onExitCommand) {
		this (titolo, null, onExitCommand);
	} //costruttore

      /**
       *  Costruttore della finestra.
       *  NB: la si crea ma NON la si mostra; usare "outputFrame2.setVisible(true);"
       */
	public OutputFrame2 (String titolo, String testataStr) {
		this (titolo, testataStr, null);
	} //costruttore

      /**
       *  Costruttore della finestra.
       *  NB: la si crea ma NON la si mostra; usare "outputFrame2.setVisible(true);"
       *  Si imposta la finestra col titolo "titolo" e il listener di uscita "onExitCommand".
       *  Inoltre la testataStr  il testo da inserire nella "testata" a caretteri cubitali.
       *  Dare "null" se non si vuole creare nessuna testata.
       */
	public OutputFrame2 (String titolo, String testataStr, Listener onExitCommand) {
    Container contentPane = getContentPane();   // NB!

    contentPane.setLayout (new BorderLayout());
    ((JPanel)contentPane).setBorder (BorderFactory.createEmptyBorder(3, 4, 6, 4));   // alto,sx,basso,dx

    if (testataStr != null)
      testata = new PanTestoSC (testataStr);
    else
      testata = null;

		textArea = new JTextArea (2, 30);
		textArea.setEditable (false);
  	JScrollPane scrollTextArea = new JScrollPane (textArea);
    scrollTextArea.setPreferredSize (new Dimension(300,80));
    scrollTextArea.setMinimumSize (new Dimension(50,30));
    scrollTextArea.setVerticalScrollBarPolicy (JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

		textField = new JTextField(30);
    textField.setMinimumSize (new Dimension(50,10));

    labTextField = new JLabel ("input line: ");  // gli do dei nomi per default

    botClrScr = new JButton ("clear");
    botClrScr.setCursor (Finestra.cursoreBottone);
    botClrScr.setVerticalTextPosition   (JButton.BOTTOM);
    botClrScr.setHorizontalTextPosition (JButton.CENTER);
    botClrScr.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"Pulisci.gif"));
    botClrScr.addActionListener (new ActionListener () {
                                    public void actionPerformed (ActionEvent e) {
                                      textArea.setText("");
                                    }
                                 });

    Config.defPropInt (CONFIG_TXT_DIM, 13);
    if (Config.chePropBool("SliderModiFont")) {
      panFontDim = new PanFontDim (Config.chePropInt(CONFIG_TXT_DIM));
      panFontDim.addChangeListener (new ChangeListener () {
                                      public void stateChanged (ChangeEvent e) {
                                        int dim = ( (JSlider)e.getSource() ).getValue();
                                        impostaFontTxt (dim);
                                      }
                                    });
    }
    impostaFontTxt (Config.chePropInt(CONFIG_TXT_DIM));

    Component spazio;

    if (testata != null)
      contentPane.add (testata, BorderLayout.NORTH);

    JPanel panInOut = new JPanel (new BorderLayout());

      JPanel panOutSpa = new JPanel (new BorderLayout());

        spazio = Box.createRigidArea(new Dimension(2,4));
        panOutSpa.add (scrollTextArea, BorderLayout.CENTER);
        panOutSpa.add (spazio,         BorderLayout.SOUTH);

      panInOut.add (panOutSpa,   BorderLayout.CENTER);

      JPanel commandLine = new JPanel ();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = GridBagConstraints.SOUTH;
        gbc.fill = GridBagConstraints.HORIZONTAL;

        gbc.gridx = 1;  gbc.gridy = 2;
        gbl.setConstraints(labTextField, gbc);
        commandLine.add(labTextField);

        gbc.gridx = 2;  gbc.gridy = 2;
        gbl.setConstraints(textField, gbc);
        commandLine.add(textField);

      panInOut.add (commandLine, BorderLayout.SOUTH);

    contentPane.add (panInOut, BorderLayout.CENTER);

    prePanBottoni = new JPanel ();

    JPanel panBottoni = new JPanel ();
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();

      panBottoni.setLayout (GBL2);

      CC2.anchor = GridBagConstraints.SOUTH;

      CC2.gridx = 1;   CC2.gridy = 1;
      GBL2.setConstraints (prePanBottoni, CC2);  // PANNELLO AGGIUNTIVO UTENTE
      panBottoni.add (prePanBottoni);

      spazio = Box.createRigidArea(new Dimension(6,4));
      CC2.gridx = 2;   CC2.gridy = 1;
      GBL2.setConstraints (spazio, CC2);
      panBottoni.add (spazio);

      CC2.gridx = 3;   CC2.gridy = 1;
      GBL2.setConstraints (botClrScr, CC2);
      panBottoni.add (botClrScr);

      spazio = Box.createRigidArea(new Dimension(6,4));
      CC2.gridx = 4;   CC2.gridy = 1;
      GBL2.setConstraints (spazio, CC2);
      panBottoni.add (spazio);

      CC2.fill   = GridBagConstraints.NONE;
      CC2.anchor = GridBagConstraints.SOUTH;

      if (Config.chePropBool("SliderModiFont")) {
        CC2.gridx = 5;   CC2.gridy = 1;
        CC2.gridheight = 2;
        GBL2.setConstraints (panFontDim, CC2);
        panBottoni.add (panFontDim);
        CC2.gridheight = 1;
      }

      panBottoni.setBorder (BorderFactory.createEmptyBorder(10, 0, 0, 0));   // alto,sx,basso,dx

    contentPane.add (panBottoni, BorderLayout.SOUTH);

    setTitle (titolo);

		// LISTENER:
		addWindowListener (new WinList());
    setDefaultCloseOperation (WindowConstants.DO_NOTHING_ON_CLOSE);

    textField.addActionListener (new InputLinePremutoInvio());

		txtAreaOut       = new TextAreaOutputStream2 (textArea);
		out              = new PrintStream (txtAreaOut);
		in               = new TextFieldInputStream2 (textField);
		inBufferedReader = new BufferedReader (new InputStreamReader(in), 1);

    if (onExitCommand != null)
      this.onExitCommand = onExitCommand;

	} //costruttore


  private void readObject (ObjectInputStream in) throws IOException, ClassNotFoundException {
    // Questo metodo  chiamato durante la deserializzazione
    in.defaultReadObject();

    // Questi campi non sono serializzabili. Li devo ricostruire.

    inBufferedReader = new BufferedReader (new InputStreamReader (this.in));
                                               // Occhio a questo ^ confusione col parametro di ingresso.
    out = new PrintStream (txtAreaOut);
  }

      /**
       *  Interna, serve per far impostare la nuova dimensione del font delle zone di testo.
       */
  protected void impostaFontTxt (int nuovaDim) {
    Config.modifPropInt (CONFIG_TXT_DIM, nuovaDim);
    Font txtFont = new Font ("DialogInput", Font.PLAIN, nuovaDim);
    textArea .setFont (txtFont);
    textField.setFont (txtFont);
  } //impostaFontTxt


      /**
       *  CLASSE INTERNA PUBBLICA! La voglio usare da chi usa la finestra!
       */
  public class WinList extends WindowAdapter implements ActionListener, Serializable {
		public void windowClosing(WindowEvent event) {
      richiediUscita();
    }

		public void actionPerformed(ActionEvent event) {
      richiediUscita();
    }

    public void richiediUscita () {
      int exit = ListExit.UscitaSN(OutputFrame2.this, null, ListExit.EXIT_ONLY); 
      if (exit == 0)   // ho premuto "s"
        Exit();
		}
	} //WinList

      /**
       *  Listener della pressione del tasto INVIO sulla linea di input.
       */
	class InputLinePremutoInvio implements ActionListener, Serializable {
    public void actionPerformed(ActionEvent event) {
      out.println (textField.getText());
      textField.setText("");
    }
  } //InputLinePremutoInvio

      /**
       *  Questi sono i costrutti di coordinamento fra il frame e l'applicazione che lo ha chiamato:
       *   - timeToExit messo a true
       *   - Notifica ai thread che aspettano sul monitor dell' OutputFrame2
       *   - Avvio del comando onExitCommand, che di default non fa nulla.
       */
	synchronized void Exit () {
    timeToExit = true;

    notifyAll();
    Thread pippo = new Thread (onExitCommand, "onExitCommand");
    pippo.start();
  } //Exit

	public synchronized void waitExit () {
	  while (!timeToExit)
 	    try {
        wait();
      }
      catch(Exception e) { }
  } //waitExit

	public interface Listener extends Serializable, Runnable {
	  public void run();
	} //Listener

      /**
       *  Rende il contenuto della TextArea di output.
       */
	public String getText () {
	  return txtAreaOut.miaTextArea.getText();
	} //getText

      /**
       *  Imposta il contenuto della TextArea di output.
       */
  public void setText (String t) {
	  txtAreaOut.miaTextArea.setText(t);
	} //setText


/*
  static public void main (String args[]) {
    try {
      UIManager.setLookAndFeel ("SOMA.gui.gigi.GigiLookAndFeel");    	
    }
    catch (Exception e) { }

    OutputFrame2 myFrame = new OutputFrame2("OutputFrame2");
    myFrame.onExitCommand = new OutputFrame2.Listener() {  //Stabilisco il comportamento all'uscita
        public void run () {
          System.exit(0);
        }
    };
    //JPanel pan = winOutFrame.prePanBottoni;
    //pan.setLayout(new GridLayout(2,3));
    //pan.add (botGoto);

    SOMA.output.Pipetta pipa = new SOMA.output.Pipetta (myFrame.in, myFrame.out);
    pipa.start();

    myFrame.pack();                // Compatto i componenti della finestra
    myFrame.setVisible (true);     // Infine rendo visibile la finestra
	}
*/

} //OutputFrame2