/**  ModelloXNS
 *     Interfaccia che usano gli oggetti che rappresentano un DNS o un PNS.
 *     In questo modo si usa una sola classe di finestra per visualizzarli (la {@link SOMA.gui.FinestraXNS}).
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.naming.PlaceID;

import javax.swing.table.TableModel;


public interface ModelloXNS {

      /**
       *  Rende una stringa contenente il tipo di Name-Service a cui il modello fa riferimento
       */
  public String cheTipo();

      /**
       *  Rende il PlaceID del place a cui appartiene il Name-Service del modello
       */
  public PlaceID perChePlace ();

      /**
       *  Rende una tabella che rappresenta la stessa tabella contenuta nel Name-Service.
       *  Il TableModel conterr tutti oggetti di classe PlaceInfo o della sua sottoclasse DomainInfo.
       *  Vedi {@link SOMA.naming.place.PlaceInfo} e {@link SOMA.naming.domain.DomainInfo}
       */
  public TableModel cheTabella ();

      /**
       *  Rende un "Pannello" contenente informazioni aggiuntive sul Name-Service.
       */
  public Pannello pannelloInfoInPiu ();

      /**
       *  Invocazione del metodo "put" del D/P-NS.
       *  Tutte le informazioni sono contenute nell'oggetto passato, che sar della classe opportuna.
       */
  public void invocaPut (Object informazioni);

      /**
       *  Invocazione del metodo "del" del D/P-NS.
       *  Viene eseguito sul PlaceID relativo alla colonna "col" passata.
       */
  public void invocaDel (PlaceID placeID);

      /**
       *  Invocazione del metodo "refresh" del D/P-NS.
       */
  public void invocaRefresh ();

      /**
       *  Rende true se si pu invocare il "refresh" (il metodo precedente)
       */
  public boolean refreshInvocabile ();


} //ModelloXNS