/**  ManipolaAgenti
 *     Finestra per mostrare e "manipolare" gli agenti presenti in un certo place (locale).
 *     @author     Luigi Antenucci
 *     @version    3.3
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.Environment;
import SOMA.naming.PlaceID;
import SOMA.naming.AgentID;
import SOMA.agent.AgentWorker;
import SOMA.agent.mobility.AgentWorkerStore;
import SOMA.network.connection.Daemon;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;


public class ManipolaAgenti extends Finestra implements FinGoto1000Listener {

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_START   = new ImageIcon(PICTURE_PATH+"AgentStart.gif");
  protected static final ImageIcon IMG_ICO_STOP    = new ImageIcon(PICTURE_PATH+"AgentStop.gif");
  protected static final ImageIcon IMG_ICO_REMOVE  = new ImageIcon(PICTURE_PATH+"AgentRemove.gif");
  protected static final ImageIcon IMG_ICO_MIGRA   = new ImageIcon(PICTURE_PATH+"AgentMigra.gif");
  protected static final ImageIcon IMG_ICO_UPDATE  = new ImageIcon(PICTURE_PATH+"AgentUpdate.gif");
  protected static final ImageIcon IMG_ICO_CANC    = new ImageIcon(PICTURE_PATH+"BotKO.gif");
  protected static final ImageIcon IMG_ICO_ZAMPA   = new ImageIcon(PICTURE_PATH+"Zampina.gif");

      /**
       *  Per memorizzare i parametri passati al costruttore,
       *  in modo che siano visibili anche agli altri metodi.
       */
  protected Environment env;
  protected AgentWorkerStore mioAgentWorkerStore;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected PanChePlace panChePlace;
  protected JLabel      labAgente, labOperaz;
  protected JTable      tabella;
  protected TableModel  modelloTabella;
  protected JScrollPane tabellaScroll;
  protected JButton     botStaSto,
                        botRemove, botGoto,
                        botUpdate, botClose;
      /**
       *  Costruzione della finestra per la visualizzazione e modifica del D/P-NS.
       *  Il {@link SOMA.gui.ModelloXNS} passato specifica il modello che usa questa finestra.
       *  Sar a lui che verranno richiesti i dati da stampare e a cui saranno
       *  inoltrati i comandi.
       */
  public ManipolaAgenti (Environment env) {
    super (70, 40);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.env = env;
    this.mioAgentWorkerStore = env.agentManager.agentWorkerStore;

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    PlaceID placeID = env.placeID;
    panChePlace = new PanChePlace (placeID);

    labAgente = new JLabel ();
    labOperaz = new JLabel ();

    botStaSto = new JButton ();
    botRemove = new JButton ();
    botGoto   = new JButton ();
    botUpdate = new JButton ();
    botClose  = new JButton ();

    botStaSto .setCursor (cursoreBottone);
    botRemove .setCursor (cursoreBottone);
    botGoto   .setCursor (cursoreBottone);
    botUpdate .setCursor (cursoreBottone);
    botClose  .setCursor (cursoreBottone);

    modelloTabella = new TabellaAgenti();
    tabella = new JTable (modelloTabella);
    tabella.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);

    ListSelectionModel lsm = tabella.getSelectionModel();
    lsm.addListSelectionListener (new TabellaListener());

    TableColumnModel modelloColonne = tabella.getColumnModel();
    modelloColonne.getColumn(2).setPreferredWidth(30);
    modelloColonne.getColumn(3).setPreferredWidth(50);

    tabellaScroll = new JScrollPane (tabella);
    tabella.setPreferredScrollableViewportSize (new Dimension(400, 84));
    tabellaScroll.setMinimumSize (new Dimension(50,30));
    tabellaScroll.updateUI();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni(this);
    botStaSto .addActionListener (bottoniera);
    botStaSto .setActionCommand("xxx");  // per ora, niente
    botRemove .addActionListener (bottoniera);
    botRemove .setActionCommand("remove");
    botGoto   .addActionListener (bottoniera);
    botGoto   .setActionCommand("goto1000");
    botUpdate .addActionListener (bottoniera);
    botUpdate .setActionCommand("update");
    botClose  .addActionListener (bottoniera);
    botClose  .setActionCommand("annulla");

    botStaSto.setIcon (IMG_ICO_STOP);
    botRemove.setIcon (IMG_ICO_REMOVE);
    botGoto  .setIcon (IMG_ICO_MIGRA);
    botUpdate.setIcon (IMG_ICO_UPDATE);
    botClose .setIcon (IMG_ICO_CANC);
    botClose .setPressedIcon(IMG_ICO_ZAMPA);

    impostaBottoni (null);

    // USO Window Listener
    mioFrame.addWindowListener (bottoniera);

    PanCentro.setLayout (new BorderLayout());

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 5, 6, 5));   // alto,sx,basso,dx

    Component spazio;

    JPanel panPlace = new JPanel();
    GridBagLayout GBL2     = new GridBagLayout();
    GridBagConstraints CC2 = new GridBagConstraints();
    panPlace.setLayout (GBL2);
      CC2.gridx = 1;   CC2.gridy = 1;
      CC2.anchor = GridBagConstraints.CENTER;
      GBL2.setConstraints (panChePlace, CC2);
      panPlace.add (panChePlace);
      spazio = Box.createRigidArea (new Dimension(4,10));
      CC2.gridx = 1;   CC2.gridy = 2;
      GBL2.setConstraints (spazio, CC2);
      panPlace.add (spazio);
      CC2.gridx = 1;   CC2.gridy = 3;
      CC2.anchor = GridBagConstraints.WEST;
      GBL2.setConstraints (labAgente, CC2);
      panPlace.add (labAgente);
    panPlace.setBorder (BorderFactory.createEmptyBorder(0, 0, 6, 0));   // alto,sx,basso,dx
    PanCentro.add (panPlace, BorderLayout.NORTH);

    PanCentro.add (tabellaScroll, BorderLayout.CENTER);

    JPanel panBott = new JPanel();
    GridBagLayout GBL3     = new GridBagLayout();
    GridBagConstraints CC3 = new GridBagConstraints();
    panBott.setLayout (GBL3);

      CC3.fill = GridBagConstraints.BOTH;

      CC3.anchor = GridBagConstraints.CENTER;
      CC3.gridx = 1;   CC3.gridy = 1;
      CC3.gridwidth = 5;
      GBL3.setConstraints (labOperaz, CC3);
      panBott.add (labOperaz);
      CC3.gridwidth = 1;

      CC3.gridx = 2;   CC3.gridy = 2;
      GBL3.setConstraints (botStaSto, CC3);
      panBott.add (botStaSto);
      CC3.gridx = 3;   CC3.gridy = 2;
      GBL3.setConstraints (botRemove, CC3);
      panBott.add (botRemove);
      CC3.gridx = 4;   CC3.gridy = 2;
      GBL3.setConstraints (botGoto, CC3);
      panBott.add (botGoto);

      spazio = Box.createRigidArea (new Dimension(10,5));
      CC3.gridx = 5;   CC3.gridy = 2;
      GBL3.setConstraints (spazio, CC3);
      panBott.add (spazio);
      CC3.gridx = 6;   CC3.gridy = 2;
      GBL3.setConstraints (botUpdate, CC3);
      panBott.add (botUpdate);

      spazio = Box.createRigidArea (new Dimension(10,5));
      CC3.gridx = 7;   CC3.gridy = 2;
      GBL3.setConstraints (spazio, CC3);
      panBott.add (spazio);
      CC3.gridx = 8;   CC3.gridy = 2;
      GBL3.setConstraints (botClose, CC3);
      panBott.add (botClose);
      panBott.setBorder (BorderFactory.createEmptyBorder(15, 10, 0, 10));   // alto,sx,basso,dx
    PanCentro.add (panBott, BorderLayout.SOUTH);

    mioFrame.setResizable (true);     // La finestra place e' ridimensionabile

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    panChePlace.distruggimi();

    super.distruggiFinestra();
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("MA_WIN_TITLE"));

    labAgente.setText (Lingua.frase("MA_CHOOSE_AGENT"));
    labOperaz.setText (Lingua.frase("MA_CHOOSE_OPER"));
    botStaSto.setText (Lingua.frase("MA_BOT_SS_STOP"));
    botRemove.setText (Lingua.frase("MA_BOT_REMOVE"));
    botGoto  .setText (Lingua.frase("MA_BOT_GOTO"));
    botUpdate.setText (Lingua.frase("MA_BOT_UPDATE"));
    botClose .setText (Lingua.frase("MA_BOT_CLOSE"));

    tabella.revalidate();

    tabella  .setToolTipText (Lingua.frase("MA_TIP_TABLE"));
    botStaSto.setToolTipText (Lingua.frase("MA_TIP_STOP"));
    botRemove.setToolTipText (Lingua.frase("MA_TIP_REMOVE"));
    botGoto  .setToolTipText (Lingua.frase("MA_TIP_GOTO"));
    botUpdate.setToolTipText (Lingua.frase("MA_TIP_UPDATE"));
    botClose .setToolTipText (Lingua.frase("MA_TIP_CLOSE"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  Interna, serve per impostare lo stato dei bottoni in base allo stato (di un agente)
       *  che viene passato come parametro.
       */
  protected void impostaBottoni (Object stato) {
    if (stato == null) {
      botStaSto.setEnabled(false);
      botRemove.setEnabled(false);
      botGoto  .setEnabled(false);
    }
    else {

      if ((stato == Daemon.OFF) || (stato == AgentWorker.IDLE) || (stato == AgentWorker.STOPPED) ) {
        botStaSto.setText(Lingua.frase("MA_BOT_SS_START"));
        botStaSto.setToolTipText (Lingua.frase("MA_TIP_START"));
        botStaSto.setIcon (IMG_ICO_START);
        botStaSto.setActionCommand("start");
        botStaSto.setEnabled(true);
      }
      else {
        botStaSto.setText(Lingua.frase("MA_BOT_SS_STOP"));
        botStaSto.setToolTipText (Lingua.frase("MA_TIP_STOP"));
        botStaSto.setIcon (IMG_ICO_STOP);
        if (stato == AgentWorker.GONE)
          botStaSto.setEnabled(false);
        else {
          botStaSto.setActionCommand("stop");
          botStaSto.setEnabled(true);
        }
      }

      boolean on = (stato == Daemon.OFF) || (stato == AgentWorker.STOPPED) ||
                   (stato == AgentWorker.GONE) || (stato == AgentWorker.KILLED);
      botRemove.setEnabled (on);

      on = (stato == Daemon.OFF) || (stato == AgentWorker.STOPPED);
      botGoto  .setEnabled(on);
   } //else
  } //impostaBottoni

      /**
       *  Metodo invocato dalla finestra "FinGoto1000" per rendere i dati dell'inserimento.
       *  Tali dati sono passati come parametro in un oggetto PlaceID che sar dato all'agentWorker.
       *  Pu generare un eccezione contenente l'indicazione dell'errore (nella lingua corrente).
       */
  public void eseguiAzioneGoto (PlaceID placeToGoTo) throws Exception {
    // Tutto  ancora a posto perch questa finestra viene "disabilitata" durante l'input del place.

    // Riprendo tutti i dati:
    int riga = tabella.getSelectedRow();

    AgentID agentID = (AgentID) modelloTabella.getValueAt (riga, TabellaAgenti.COL_IDENT);
    if (agentID == null)
      throw new Exception (Lingua.frase("MA_ERR_AI_NULL"));

    // e quindi l'AgentWorker associato
    AgentWorker agentWorker = mioAgentWorkerStore.getWorker (agentID);
    if (agentWorker == null)
      throw new Exception (Lingua.frase("MA_ERR_AW_NULL"));

    try {

      agentWorker.go (placeToGoTo);   // Go Jhonny go go go! Jhonny B.Goode.

    }
    catch (Exception ecc) {
      throw new Exception (Lingua.frase("MA_ERR_CANT_GO"));
    }

    SwingUtilities.invokeLater (new Runnable () {
            public void run () {
                  tabella.clearSelection();
                  impostaBottoni (null);
            } //run
    }); //invokeLater

  } //eseguiAzioneGoto


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {
    protected ManipolaAgenti miaManipolaAgenti;

    public ListBottoni (ManipolaAgenti miaManipolaAgenti) {
      this.miaManipolaAgenti = miaManipolaAgenti;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("annulla"))    // Considera subito un "Annulla"
        miaManipolaAgenti.distruggiFinestra();   // In ogni caso distruggo questa finestra
      else
        if (azione.equals("update")) {
          tabella.clearSelection();
          impostaBottoni (null);
          tabella.revalidate();
        }
        else {
          int riga = tabella.getSelectedRow();
          if (riga >= 0) {
            // Prelevo i dati dalla tabella - OTTENGO L'AgentID DAL MODELLO (prima colonna)
            AgentID agentID = (AgentID) modelloTabella.getValueAt (riga, TabellaAgenti.COL_IDENT);

            if (agentID != null) {
              // e quindi l'AgentWorker associato
              AgentWorker agentWorker = mioAgentWorkerStore.getWorker (agentID);

              // ORA CONSIDERO LE POSSIBILI AZIONI:
              try {

                if (azione.equals("start"))
                  agentWorker.start();
                else
                  if (azione.equals("stop"))
                    agentWorker.stop();
                  else
                    if (azione.equals("remove")) {
                      agentWorker.remove();
                      tabella.clearSelection();
                      impostaBottoni (null);
                    }
                    else
                      if (azione.equals("goto1000")) {
                        FinGoto1000 fin = new FinGoto1000 (miaManipolaAgenti, env.actionPlace);
                        // Questa finestra verr bloccata dalla FinGoto1000
                        // fintanto che non verr distrutta.
                        // Alla chiusura con "OK" viene invocato il metodo
                        // "eseguiAzioneGoto" di questa finestra.
                      }
              }
              catch (Exception eccez) {
                OiDialogoi.mostraErrore (eccez, mioFrame);
              }
            }
          } //if riga>=0

          SwingUtilities.invokeLater (new Runnable () {
                  public void run () {
                    int r = tabella.getSelectedRow();
                    if (r >= 0) {
                      tabella.clearSelection();
                      tabella.addRowSelectionInterval(r,r);
                    }
                    tabella.revalidate();
                  } //run
          }); //invokeLater
        } //else

    } //actionPerformed

    public void windowClosing (WindowEvent e)   {
      miaManipolaAgenti.distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni


      /**
       *  CLASSE INTERNA CHE DEFINISCE IL "MODELLO" A CUI SI RIFERISCE LA TABELLA DEGLI AgentID.
       *  Vedi classe {@link javax.swing.table.AbstractTableModel}
       *  Nota Bene: c' un side-effect sulla variabile "mioAgentWorkerStore" della classe contenitrice!
       */
  public class TabellaAgenti extends AbstractTableModel {
      /**
       *  Costanti per essere indipendenti dalla colonna.
       */
    public static final  int COL_IDENT = 0;
    public static final  int COL_STATO = 2;

      /**
       *  Rende il numero di colonne della tabella.
       */
    public int getColumnCount () {
      return 4;
    } //getColumnCount

      /**
       *  Rende il numero di righe della tabella.
       */
    public int getRowCount () {
      // Chiedo all'AgentWorkerStore l'elenco di tutti i dominii
      AgentID[] arrPlaceID = mioAgentWorkerStore.cheElencoAgenti();
      // Se la precedente linea d "errore" significa che manca il
      // metodo "cheElencoAgenti()" aggiunto da Luigi all'AgentWorkerStore
      return arrPlaceID.length;
    } //getRowCount

      /**
       *  Rende il valore (sottoforma di oggetto) contenuto nella tabella in posizione (row,col).
       */
    public Object getValueAt (int row, int col) {
      // Chiedo all'AgentWorkerStore l'elenco di tutti i dominii
      AgentID[] arrAgentID = mioAgentWorkerStore.cheElencoAgenti();
      // Se la precedente linea d "errore" significa che manca il
      // metodo "cheElencoAgenti()" aggiunto da Luigi all'AgentWorkerStore

      // Prelevo l'AgentWorker ralativo alla riga in esame
      if ((row >= 0) && (row < arrAgentID.length)) {
        AgentWorker agentWorker = mioAgentWorkerStore.getWorker (arrAgentID[row]);

        // E rendo l'oggetto relativo alla colonna (basato sull'AgentWorker trovato)
        switch (col) {
          case  0: return arrAgentID[row];
          case  1: return agentWorker.agent.getClass().getName();
          case  2: return agentWorker.getStatus();
          case  3: try {  // NB: SE L'AGENTE NON E' RINTRACCIABILE, NON HA LA MAILBOX!
                     if (agentWorker.agent.mailbox.isMessage())
                       return Lingua.frase("MA_AG_MESSA_SI");
                     else
                       return Lingua.frase("MA_AG_MESSA_NO");
                   }
                   catch (NullPointerException nullo) {
                     return Lingua.frase("MA_AG_MESSA_NADA");
                   }
          default: return null;
        }
      }
      else
        return null;
    } //getValueAt

      /**
       *  Rende il nome della colonna "col", cio l'informazione "intensiva".
       */
    public String getColumnName (int col) {
      switch (col) {
        case  0: return Lingua.frase("MA_AG_AGEID");
        case  1: return Lingua.frase("MA_AG_CLASS");
        case  2: return Lingua.frase("MA_AG_STATO");
        case  3: return Lingua.frase("MA_AG_MESSA");
        default: return null;
      }
    } //getColumnName

      /**
       *  Rende la classe degli oggetti relativi alla colonna "col".
       *  Necessaria per un buon "allineamento" delle stringhe a sinistra e dei numeri a destra!
       */
    public Class getColumnClass (int col) {
          return getValueAt(0,col).getClass();
    } //getColumnClass

      /**
       *  La cella in posione (row,col) pu essere modificata dall'utente?
       */
    public boolean isCellEditable (int row, int col) {
      return false;
    } //isCellEditable

  } //TabellaAgenti (classe)


      /**
       *  CLASSE INTERNA CHE FUNGE DA ASCOLTATORE DELLE SELEZIONI FATTE SULLA TABELLA.
       */
  public class TabellaListener implements ListSelectionListener {

    public void valueChanged (ListSelectionEvent e) {
      int riga = tabella.getSelectedRow();    // OTTENGO IL N.DELLA RIGA SELEZIONATA
      if (riga >= 0) {
        // ESTRAGGO LE INFO DAL MODELLO (colonna di stato)!
        Object stato = modelloTabella.getValueAt (riga, TabellaAgenti.COL_STATO);
        impostaBottoni (stato);
      }
    } //valueChanged
  } //TabellaListener

} //ManipolaAgenti