/**  ListExit
 *     Listener per la chiusura della finestra e l'uscita dal sistema!
 *     Apre una finestra in cui chiede se si vuole veramente uscire.
 *     In caso affermativo distrugge la finestra (a cui  associato) e
 *     esce dal sistema.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2
 */
package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.io.Serializable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;


public class ListExit extends WindowAdapter implements ActionListener, Serializable {

      /**
       *  Costanti per il tipo di uscita.
       */
  public static final  int EXIT_SOMA = 0;
  public static final  int EXIT_ONLY = 1;

      /**
       *  Riferimenti ai dati passati al costruttore.
       */
  protected JFrame   cheFrame;
  protected Finestra cheFin;
  protected int      exitCosa;

      /**
       *  Costruttore. Il parametro pu essere EXIT_xxx.
       */
  public ListExit (int exitCosa) {
    this (null, null, exitCosa);
  } //costruttore

      /**
       *  Costruttore, con l'oggetto Finestra da distruggere (il secondo parametro pu essere EXIT_xxx)
       */
  public ListExit (Finestra cheFin, int exitCosa) {
    this (null, cheFin, exitCosa);         // nessun frame a cui associare il "dialog"
  } //costruttore

      /**
       *  Costruttore della richiesta di uscita dal sistema.
       *  Il parametro "cheFrame" serve solo per indicare la finestra JFrame su 
       *  cui "modalizzare" il dialogo di richiesta; se contiene "null", il 
       *  dialogo apparir in mezzo al video.
       *  Invece, "cheFin" indica l'oggetto Finestra su cui si vuole che venga 
       *  invocato il metodo "distruggiFinestra" prima che venga eseguita la 
       *  chiusura del sistema;  vedi {@link SOMA.gui.Finestra#distruggiFinestra()}.
       *  Se contiene "null", si eseguir subito l'uscita dal sistema.
       *  Ricorda: la "distruggiFinestra" permette di salvare le ultime modifiche 
       *  fatte a "Config", come ad esempio la nuova lingua, l'apparenza, la posizione 
       *  e la dimensione della finestra, ecc..
       *  Il parametro "exitCosa" specifica se stampare "uscire da SOMA" o solo "uscire?". Vedi EXIT_xxx.
       */
  public ListExit (JFrame cheFrame, Finestra cheFin, int exitCosa) {
    this.cheFrame = cheFrame;
    this.cheFin   = cheFin;
    this.exitCosa = exitCosa;
    Lingua.caricaFileDiLingua (ListExit.class);   // CARICO FILE DI LINGUA
  } //costruttore

      /**
       *  Metodo richiesto dalla classe WindowAdapter.
       */
  public void windowClosing (WindowEvent e)   { 
    UscitaSN (cheFrame, cheFin, exitCosa);
  } //windowClosing

      /**
       *  Metodo richiesto dall'interfaccia ActionListener.
       */
  public void actionPerformed (ActionEvent e) { 
    UscitaSN (cheFrame, cheFin, exitCosa);
  } //actionPerformed

  

      /**
       *  Richiesta vera e propria di uscita dal sistema.
       *  Vedi metodo omonimo successivo.
       */
  public static int UscitaSN (int exitCosa) {
    return UscitaSN (null, null, exitCosa);
  } //UscitaSN

      /**
       *  Richiesta vera e propria di uscita dal sistema.
       *  Nel caso che exitCosa=EXIT_ONLY rende 0 = s, 1=no; altrimenti potr rendere solo 1.
       */
  public static int UscitaSN (JFrame cheFrame, Finestra cheFinestra, int exitCosa) {
    Object[] opzioni = {Lingua.frase("BOT_EXIT_YES"), Lingua.frase("BOT_EXIT_NO")};
    ImageIcon iconetta = new ImageIcon(Finestra.PICTURE_PATH+"Morte.gif");
    String frase;
    if (exitCosa == EXIT_SOMA)
      frase = Lingua.frase("REALLY_EXIT_SOMA");
    else
      frase = Lingua.frase("REALLY_EXIT_SN");
    int E = JOptionPane.showOptionDialog (cheFrame,                      // Frame padre
                                          frase,
                                          Lingua.frase("CONFIRM_EXIT"),
                                          JOptionPane.YES_NO_OPTION,
                                          JOptionPane.WARNING_MESSAGE,
                                          iconetta,
                                          opzioni,
                                          null);  //opzione "evidenziata" (ma NON selezionata)
    if ((E == 0) && (exitCosa == EXIT_SOMA)) {
      if (cheFinestra != null)
        cheFinestra.distruggiFinestra();
      System.exit (0);        // USCITA DAL SISTEMA!
    }
    return E;
  } //UscitaSN

} //ListExit