/**  LancioAgente
 *     Finestra per definire e lanciare un AGENTE in un certo place
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.naming.PlaceID;
import SOMA.Environment;
import SOMA.security.SecurityEnvironment;

import java.util.Enumeration;
import java.util.Vector;
import java.util.StringTokenizer;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class LancioAgente extends Finestra implements PanPlaceListener {

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_LANCIO  = new ImageIcon(PICTURE_PATH+"Lancio.gif");
  protected static final ImageIcon IMG_ICO_CANCEL  = new ImageIcon(PICTURE_PATH+"BotKO.gif");
  protected static final ImageIcon IMG_ICO_ZAMP    = new ImageIcon(PICTURE_PATH+"Zampina.gif");

  // Variabili protette:
      /**
       *  Finestra genitore (da disabilitare).
       */
  protected Finestra finGenitore;

      /**
       *  ActionPlace di riferimento, a cui inviare le richieste di qualsiasi dato.
       *  La cosa principale da chiedere  il PlaceID; poi gli si pu chiedere di lanciare l'agente!
       *  Pu venir modificato se viene dato un oggetto "Anagrafe".
       */
  protected ActionPlace actionPlace;

      /**
       *  Memorizzazione del PlaceID richiesto all'ActionPlace.
       *  Utile per non doverlo richiedere in continuazione.
       *  Pu venir modificato se viene dato un oggetto "Anagrafe".
       */
  protected PlaceID placeID;

      /**
       *  Lista degli agenti possibili passata al costruttore.
       *  Se la lista  "null", viene chiesto a "ActionPlace" di fornirne una;
       *  se invece  vuota (senza elementi) o ha almeno un elemento, viene
       *  usata lei senza chiedere nulla all'ActionPlace.
       */
  protected Vector elencoAgentiPredefinito;

      /**
       *  L'utente pu cambiare il place tramite la combobox?
       *  Se viene passato un oggetto Anagrafe (non "null"), lo si usa per 
       *  ottenere il nuovo ActionPlace del nuovo place
       */
  protected Anagrafe anagrafe;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel     labSpiega,
                       labAgent,
                       labParam,
                       labSecurity,
                       labSecProf,
                       labSecPass,
                       labAltreOpz;
  protected PanPlace   panPlace;
  protected JComboBox  comboAgent;
  protected JTextField txtParam,
                       txtSecProf;
  protected JPasswordField txtSecPass;
  protected JCheckBox  chkSysCL, chkNoTr, chkNoSt;   // chkSysCL c' ma non lo uso!
  protected JButton    botLancia, botCanc;

  protected PanTestoSC testata;


      /**
       *  Costruzione della finestra per l'input dei dati di lancio di un agente.
       *  L' "ActionPlace" indica l'oggetto ActionPlace relativo al place iniziale in cui si vuole
       *  lanciare l'agente. A tale oggetto verranno inoltrate tutte le richieste di dati e il
       *  comando finale di lancio di un agente.
       *  Invece "finGenitore" indica la finestra genitore che verr disabilitata fintantoch 
       *  la finestradi lancio esister (cio questa finestra sar "modale" a quella del genitore).
       *  Nota: se non si vuole bloccare la finestra genitore, porre  finGenitore=null.
       *  IMPORTANTE: chiamando questo metodo si impone all'utente che il Place di lancio NON POSSA
       *  essere cambiato! Infatti l'unico riferiemtno dato  l"ActionPlace" associato al Place e a
       *  esso NON POSSONO ESSERE RICHIESTI DATI RIGUARDANTI ALTRI PLACE!
       */
  public LancioAgente (ActionPlace actionPlace, Finestra finGenitore) {
    this (actionPlace, finGenitore, null, null);
  } //costruttore

      /**
       *  Come il metodo precedente, ma il parametro "elencoAgentiPredefinito" contiene un elenco di
       *  stringhe corrispondenti ai nomi di tutti gli agenti lanciabili.
       *  Pu servire per limitare la "visione" degli agenti lanciabili.
       *  Se il Vector "elencoAgentiPredefinito"  "null", viene chiesto all'"ActionPlace" di fornire una
       *  lista con gli agenti possibili; se invece  vuota (nessun elemento) o ha almeno un elemento,
       *  viene usata lei stessa senza chiedere nulla all'ActionPlace.
       *  Questo passaggio per l'ActionPlace serve per facilitare la futura interrogazione "remota". 
       *  Si potr "riusare" questa finestra!
       *  Il Place di lancio NON pu essere cambiato!
       */
  public LancioAgente (ActionPlace actionPlace, Finestra finGenitore,
                       Vector elencoAgentiPredefinito) {
    this (actionPlace, finGenitore, null, elencoAgentiPredefinito);
  } //costruttore

      /**
       *  Come il primo costruttore.
       *  Ha la particolarit, per, che viene passato anche un oggetto {@link SOMA.gui.Anagrafe}.
       *  All'utente sar quindi data la possibilit di CAMBIARE IL PLACE DI LANCIO, poich verr
       *  richiesto all'oggetto Anagrafe (dato qui) di rendere l'ActionPlace del nuovo Place.
       */
  public LancioAgente (ActionPlace actionPlace, Finestra finGenitore,
                       Anagrafe anagrafe) {
    this (actionPlace, finGenitore, anagrafe, null);
  } //costruttore

      /**
       *  Come il secondo e il terzo costruttore.
       *  Viene passato l'oggetto {@link SOMA.gui.Anagrafe} e anche un elenco fisso di nomi di agenti.
       *  All'utente sar quindi data la possibilit di CAMBIARE IL PLACE DI LANCIO.
       */
  public LancioAgente (ActionPlace actionPlace, Finestra finGenitore,
                       Anagrafe anagrafe, Vector elencoAgentiPredefinito) {
    super (60, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.actionPlace = actionPlace;
    this.anagrafe    = anagrafe;
    this.finGenitore = finGenitore;
    this.elencoAgentiPredefinito = elencoAgentiPredefinito;

    placeID = actionPlace.chePlaceID ();  // Chiedo e salvo il PlaceID corrente.

    Config.defProp ("UltimoAgente",  "TheAgent");        // Per default, l'ultimo agente era il mio!
    Config.defProp ("UltimiParam",   "");
    Config.defPropVariabile ("UltimoProfilo", "");  // "Variabile" perch  definita anche da "FinProfileLogin"

    if (finGenitore != null)
      finGenitore.disabilitaFinestra();

    costruisciFinestra();

  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    testata     = new PanTestoSC ();

    labSpiega   = new JLabel ();
    labAgent    = new JLabel ();
    labParam    = new JLabel ();
    labSecurity = new JLabel ();
    labSecProf  = new JLabel ();
    labSecPass  = new JLabel ();
    labAltreOpz = new JLabel ();

    botLancia   = new JButton ();
    botCanc     = new JButton ();

    botLancia.setCursor (cursoreBottone);
    botCanc  .setCursor (cursoreBottone);

    if (anagrafe == null) {         // Disabilito il pannello del place se non 
      panPlace    = new PanPlace (PanPlace.INPUT_PLACE, actionPlace);
      panPlace.disabilitami();                      // voglio che sia modificabile il place.
    }
    else {
      panPlace    = new PanPlace (PanPlace.INPUT_PLACE, anagrafe, placeID);
      panPlace.addPanPlaceListener (this);    // ASCOLTO UN CAMBIO DI CONTENUTO DEL PANNELLO
    }

    comboAgent  = new JComboBox ();
    RiempiComboAgente ();

    txtParam    = new JTextField (40);
    txtParam.setText (Config.cheProp("UltimiParam"));

    txtSecProf  = new JTextField (30);
    txtSecProf.setText (Config.cheProp("UltimoProfilo"));
    txtSecPass  = new JPasswordField (10);
    AbilitaCampiSicurezza();

    chkSysCL    = new JCheckBox ();
    chkNoTr     = new JCheckBox ();
    chkNoSt     = new JCheckBox ();
    chkSysCL.setSelected (false);
    chkNoTr .setSelected (false);
    chkNoSt .setSelected (false);

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni(this);
    botLancia.addActionListener (bottoniera);
    botLancia.setActionCommand("Lancia");
    botCanc.addActionListener (bottoniera);
    botCanc.setActionCommand("Annulla");

    botLancia.setIcon (IMG_ICO_LANCIO);
    botCanc.setIcon (IMG_ICO_CANCEL);
    botCanc.setPressedIcon(IMG_ICO_ZAMP);


    txtParam  .addActionListener (bottoniera);
    txtParam  .setActionCommand("Lancia");
    txtSecProf.addActionListener (bottoniera);
    txtSecProf.setActionCommand("Lancia");
    txtSecPass.addActionListener (bottoniera);
    txtSecPass.setActionCommand("Lancia");

    // USO Window Listener
    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL     = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 25, 8, 25));   // alto,sx,basso,dx

    CC.gridx = 1;   CC.gridy = 0;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (testata, CC);
    PanCentro.add (testata);

    Component spazio = Box.createRigidArea(new Dimension(4,10));
    CC.gridx = 1;   CC.gridy = 1;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 2;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    panPlace.setBorder (BorderFactory.createEmptyBorder(4, 60, 10, 0));   // alto,sx,basso,dx
    CC.gridx = 1;   CC.gridy = 3;
    GBL.setConstraints (panPlace, CC);
    PanCentro.add (panPlace);

    JPanel panAgente = new JPanel();  // 2 righe e 1 colonna
      panAgente.setBorder (BorderFactory.createEmptyBorder(0, 30, 10, 0));   // alto,sx,basso,dx
      GridBagLayout GBL4     = new GridBagLayout();
      GridBagConstraints CC4 = new GridBagConstraints();
      panAgente.setLayout (GBL4);

      CC4.gridx = 1;   CC4.gridy = 1;
      CC4.anchor = GridBagConstraints.EAST;
      GBL4.setConstraints (labAgent, CC4);
      panAgente.add (labAgent);

      CC4.gridx = 2;   CC4.gridy = 1;
      CC4.anchor = GridBagConstraints.WEST;
      GBL4.setConstraints (comboAgent, CC4);
      panAgente.add (comboAgent);

      spazio = Box.createRigidArea (new Dimension(4,6));
      CC4.gridx = 2;   CC4.gridy = 2;
      GBL4.setConstraints (spazio, CC4);
      panAgente.add (spazio);

      CC4.gridx = 1;   CC4.gridy = 3;
      CC4.anchor = GridBagConstraints.EAST;
      GBL4.setConstraints (labParam, CC4);
      panAgente.add (labParam);

      CC4.gridx = 2;   CC4.gridy = 3;
      CC4.anchor = GridBagConstraints.WEST;
      GBL4.setConstraints (txtParam, CC4);
      panAgente.add (txtParam);

      spazio = Box.createRigidArea (new Dimension(4,12));
      CC4.gridx = 2;   CC4.gridy = 4;
      GBL4.setConstraints (spazio, CC4);
      panAgente.add (spazio);

      CC4.gridx = 1;   CC4.gridy = 7;
      CC4.anchor = GridBagConstraints.WEST;
      GBL4.setConstraints (labSecurity, CC4);
      panAgente.add (labSecurity);

      CC4.gridx = 1;   CC4.gridy = 8;
      CC4.anchor = GridBagConstraints.EAST;
      GBL4.setConstraints (labSecProf, CC4);
      panAgente.add (labSecProf);

      CC4.gridx = 2;   CC4.gridy = 8;
      CC4.anchor = GridBagConstraints.WEST;
      GBL4.setConstraints (txtSecProf, CC4);
      panAgente.add (txtSecProf);

      spazio = Box.createRigidArea (new Dimension(4,6));
      CC4.gridx = 2;   CC4.gridy = 9;
      GBL4.setConstraints (spazio, CC4);
      panAgente.add (spazio);

      CC4.gridx = 1;   CC4.gridy = 10;
      CC4.anchor = GridBagConstraints.EAST;
      GBL4.setConstraints (labSecPass, CC4);
      panAgente.add (labSecPass);

      CC4.gridx = 2;   CC4.gridy = 10;
      CC4.anchor = GridBagConstraints.WEST;
      GBL4.setConstraints (txtSecPass, CC4);
      panAgente.add (txtSecPass);

      spazio = Box.createRigidArea (new Dimension(4,12));
      CC4.gridx = 2;   CC4.gridy = 12;
      GBL4.setConstraints (spazio, CC4);
      panAgente.add (spazio);

      CC4.gridx = 1;   CC4.gridy = 16;
      GBL4.setConstraints (labAltreOpz, CC4);
      panAgente.add (labAltreOpz);

      CC4.gridx = 2;   CC4.gridy = 16;
      GBL4.setConstraints (chkNoTr, CC4);
      panAgente.add (chkNoTr);

      CC4.gridx = 2;   CC4.gridy = 17;
      GBL4.setConstraints (chkNoSt, CC4);
      panAgente.add (chkNoSt);

    /* NON USO IL chkSysCL !
      CC4.gridx = 2;   CC4.gridy = 18;
      GBL4.setConstraints (chkSysCL, CC4);
      panAgente.add (chkSysCL);
     */

    CC.gridx = 1;   CC.gridy = 5;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (panAgente, CC);
    PanCentro.add (panAgente);

    CC.fill = GridBagConstraints.VERTICAL;

    CC.gridx = 1;   CC.gridy = 22;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (botLancia, CC);
    PanCentro.add (botLancia);

    CC.gridx = 1;   CC.gridy = 22;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (botCanc, CC);
    PanCentro.add (botCanc);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    panPlace.distruggimi();

    super.distruggiFinestra();

    if (finGenitore != null) {
      finGenitore.abilitaFinestra();
      finGenitore.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Disabilita la finestra. Vedi in superclasse {@link SOMA.gui.Finestra}.
       */
  public void disabilitaFinestra () {
    super.disabilitaFinestra ();
    labSpiega.setEnabled (false);
    labAgent .setEnabled (false);
    labParam .setEnabled (false);
    panPlace  .disabilitami ();
    comboAgent.setEnabled (false);
    txtParam  .setEditable (false);
    chkSysCL  .setEnabled (false);
    chkNoTr   .setEnabled (false);
    chkNoSt   .setEnabled (false);
    botLancia .setEnabled (false);
    botCanc   .setEnabled (false);
    AbilitaCampiSicurezza(false);
  } //disabilitaFinestra

      /**
       *  Abilita la finestra (precedentemente disabilitata). Vedi in superclasse {@link SOMA.gui.Finestra}.
       */
  public void abilitaFinestra () {
    super.abilitaFinestra ();
    labSpiega.setEnabled (true);
    labAgent .setEnabled (true);
    labParam .setEnabled (true);
    panPlace.abilitami ();
    comboAgent.setEnabled (true);
    txtParam.setEditable (true);
    chkSysCL.setEnabled (true);
    chkNoTr .setEnabled (true);
    chkNoSt .setEnabled (true);
    botLancia.setEnabled (true);
    botCanc  .setEnabled (true);
    AbilitaCampiSicurezza();
  } //abilitaFinestra

      /**
       *  Riempie il ComboBox "comboAgent" con l'elenco di tutti i nomi degli agenti.
       */
  protected void RiempiComboAgente () {
    SwingUtilities.invokeLater (new Runnable () {
        public void run () {
          try {
            comboAgent.removeAllItems();
            // BACO DI SWING SOTTO WIN95: genera eccezione se il combo-box  vuoto!
            // NB: sotto Win NT funziona tutto correttamente (no eccezione)
          }
          catch (Exception e) { }

          Vector elencoAgenti;
          if (elencoAgentiPredefinito == null)
            elencoAgenti = actionPlace.cheElencoAgenti();  // Chiedo all'actionPlace
          else
            elencoAgenti = elencoAgentiPredefinito;

          Enumeration enum = elencoAgenti.elements();
          while (enum.hasMoreElements()) {
            comboAgent.addItem ((String)enum.nextElement());
          }

          try {
            comboAgent.setSelectedItem (Config.cheProp("UltimoAgente"));
          }
          catch (Exception e) { }

          botLancia.setEnabled (elencoAgenti.size() > 0);   // Disabilito bottone "lancia" se NON ho nessun agente!

          comboAgent.revalidate();
        } //run
    }); //invokeLater
  } //RiempiComboAgente

      /**
       *  Abilita o disabilita i campi della sicurezza a seconda dell'Environment.
       */
  protected void AbilitaCampiSicurezza () {
    Environment env = actionPlace.cheEnv ();
    AbilitaCampiSicurezza (env instanceof SecurityEnvironment);
  } //AbilitaCampiSicurezza

  protected void AbilitaCampiSicurezza (final boolean abilita) {
    SwingUtilities.invokeLater (new Runnable () {
        public void run () {
          labSecProf .setEnabled (abilita);
          labSecurity.setEnabled (abilita);
          labAltreOpz.setEnabled (abilita);
          labSecPass .setEnabled (abilita);
          txtSecProf .setEditable(abilita);
          txtSecPass .setEnabled (abilita);
        } //run
    }); //invokeLater
  } //AbilitaCampiSicurezza

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("LA_WIN_TITLE"));

    testata   .setText (Lingua.frase("LA_TESTATA"));

    labSpiega .setText (Lingua.frase("LA_INSERT_DATA"));
    labAgent  .setText (Lingua.frase("LA_AGENT"));
    labParam  .setText (Lingua.frase("LA_PARAM"));
    labSecurity.setText (Lingua.frase("LA_SECURITY"));
    labSecProf .setText (Lingua.frase("LA_PROFILE"));
    labSecPass .setText (Lingua.frase("LA_PASSWORD"));
    labAltreOpz.setText (Lingua.frase("LA_OTHER_OPT"));

    botLancia .setText (Lingua.frase("LA_LAUNCH"));
    botCanc   .setText (Lingua.frase("LA_CANCEL"));

    chkSysCL  .setText (Lingua.frase("LA_SYS_CL"));
    chkNoTr   .setText (Lingua.frase("LA_NO_TRAC"));
    chkNoSt   .setText (Lingua.frase("LA_NO_START"));

    comboAgent .setToolTipText (Lingua.frase("LA_TIP_AGENT"));
    txtParam   .setToolTipText (Lingua.frase("LA_TIP_PARAM"));
    chkSysCL   .setToolTipText (Lingua.frase("LA_TIP_SYSCL"));
    chkNoTr    .setToolTipText (Lingua.frase("LA_TIP_NOTRA"));
    chkNoSt    .setToolTipText (Lingua.frase("LA_TIP_NOSTA"));
    botLancia  .setToolTipText (Lingua.frase("LA_TIP_LAUNCH"));
    botCanc    .setToolTipText (Lingua.frase("LA_TIP_CANCEL"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  METODO RICHIESTO DALL'INTERFACCIA "PanPlaceListener".
       *  Mi serve per ascoltare i cambi di Place contenuto nel pannello "panPlace".
       *  Nota: il cambio di Place causa necessariamente un CAMBIO DI ActionPlace relativo!
       *  Pu essere fatto solo se si passa un oggetto "Anagrafe".
       */  
  public void panPlaceCambiato () {
    PlaceID placeSelez = panPlace.chePlace();
    if ((placeSelez != null) && (anagrafe != null)) {
      ActionPlace actionPlaceSelez = anagrafe.cheActionPlace (placeSelez);
      if (actionPlaceSelez != null) {
        actionPlace = actionPlaceSelez;   // ORA LI ASSEGNO (SONO SICURO CHE NON SONO "null")
        placeID     = placeSelez;
        RiempiComboAgente ();
        AbilitaCampiSicurezza ();
      }
    }
  } //panPlaceCambiato


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {
    protected LancioAgente mioLancioAgente;

    public ListBottoni (LancioAgente mioLancioAgente) {
      this.mioLancioAgente = mioLancioAgente;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("Lancia")) {
        // Prelevo i parametri dalla GUI e li passo a
        // un THREAD apposta che esegue la creazione.
        // Questo per NON bloccare il gestore degli eventi e 
        // la GUI nel caso che la "creazione" impiegasse
        // un tempo troppo lungo.

        // NON PRELEVO IL PLACE DI LANCIO --> HO GIA' L'ActionPlace a cui riferirmi.
        // SE IL PLACE FOSSE STATO CAMBIATO, "actionPlace" CONTERRA' IL NUOVO ActionPlace!

        final String nomeAgente = (String) comboAgent.getSelectedItem();    // PRELEVO IL NOME DELL'AGENTE DA LANCIARE
        // NOTA BENE: SENZA PERCORSO E SENZA ESTENSIONE!

        Config.modifProp ("UltimoAgente", nomeAgente);          // Si ricorder l'ultimo agente selezionato.

        String paramAgente = (String) txtParam.getText();       // PRELEVO I PARAMETRI AGGIUNTIVI
        Config.modifProp ("UltimiParam", paramAgente);
        
        StringBuffer[] arrTmp = new StringBuffer[100];
		StringTokenizer separatore = new StringTokenizer (paramAgente);
        int i = 0;
        while (separatore.hasMoreTokens()) {
          arrTmp[i] = new StringBuffer (separatore.nextToken());    // (li devo mettere in un array!)
		  if (arrTmp[i].charAt(0)=='"')                     
		  { arrTmp[i].deleteCharAt(0);
		    arrTmp[i].append(' ');
			arrTmp[i].append(separatore.nextToken());
			arrTmp[i].deleteCharAt(arrTmp[i].length()-1);
		  } //if                    
          i++;
        } //while
        final String[] arrParam = new String [i];
        for (int j=0; j<i; j++)
          arrParam[j] = arrTmp[j].toString();

        Debug.outln ("LancioAgente - lanciando "+nomeAgente+" coi parametri:");
        for (int k=0; k<arrParam.length; k++)
          Debug.outln ("param "+k+" = "+arrParam[k]);

        final String profileFile, password;
        final Environment env = actionPlace.cheEnv();
        if (env instanceof SecurityEnvironment) {
          profileFile = txtSecProf.getText();
          Config.modifProp ("UltimoProfilo", profileFile);
          password    = new String(txtSecPass.getPassword());
        }
        else {
          profileFile = null;
          password    = null;
        }

        final boolean usaSysClassLoader = chkSysCL.isSelected();            // PRELEVO LE OPZIONI
        final boolean rintracciabile    = (! chkNoTr.isSelected());
        final boolean nonFarloPartire   = chkNoSt.isSelected();

        try {
          Config.salvaPropUtente();
        }
        catch (Exception E) { }

        // CREAZIONE E LANCIO DELL'AGENTE: MA LO CREO IN UN THREAD SEPARATO
        Thread esecutore = new Thread ("Agent Launcher") {
                public void run() {
                  try {

                    mioLancioAgente.disabilitaFinestra();

                    if (finGenitore != null)
                      finGenitore.abilitaFinestra();    // Lascio GIA' libero la fin. genitore!

                    if (env instanceof SecurityEnvironment)
                      actionPlace.lanciaAgente (nomeAgente, arrParam,
                                                usaSysClassLoader, rintracciabile, nonFarloPartire,
                                                profileFile, password);
                    else
                      actionPlace.lanciaAgente (nomeAgente, arrParam,
                                                usaSysClassLoader, rintracciabile, nonFarloPartire);
                    // Se sono qui, tutto ok!

                    if (nonFarloPartire) {
                      OiDialogoi.mostraMessaggio (Lingua.frase("LA_OK_NOTLAUNCH"), mioFrame, IMG_ICO_LANCIO);
                    }

                    mioLancioAgente.distruggiFinestra();   // Distruggo questa finestra

                  }
                  catch (Exception eccezione) {
                    if (finGenitore != null)
                      finGenitore.disabilitaFinestra();    // Ritorno a bloccare la fin.genitore
                    OiDialogoi.mostraErrore (eccezione, mioFrame);
                    mioLancioAgente.abilitaFinestra();
                  } //catch
                } //run
        }; //esecutore (Thread)
        esecutore.start();
        OiDialogoi.mostraMessaggio (Lingua.frase("LA_OK_LAUNCHING"), mioFrame);

      } //if "Lancia"
      else  // in ogni caso considera un "Annulla"
        mioLancioAgente.distruggiFinestra();   // In ogni caso distruggo questa finestra

    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      mioLancioAgente.distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

} //LancioAgente